/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.scala;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.api.CoreCouchbaseOps;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreKvOps;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.scala.AsyncBinaryCollection;
import com.couchbase.client.scala.AsyncCollectionBase;
import com.couchbase.client.scala.codec.JsonSerializer;
import com.couchbase.client.scala.codec.Transcoder;
import com.couchbase.client.scala.env.ClusterEnvironment;
import com.couchbase.client.scala.kv.ExistsOptions;
import com.couchbase.client.scala.kv.ExistsOptions$;
import com.couchbase.client.scala.kv.ExistsResult;
import com.couchbase.client.scala.kv.GetAndLockOptions;
import com.couchbase.client.scala.kv.GetAndLockOptions$;
import com.couchbase.client.scala.kv.GetAndTouchOptions;
import com.couchbase.client.scala.kv.GetAndTouchOptions$;
import com.couchbase.client.scala.kv.GetOptions;
import com.couchbase.client.scala.kv.GetOptions$;
import com.couchbase.client.scala.kv.GetResult;
import com.couchbase.client.scala.kv.InsertOptions;
import com.couchbase.client.scala.kv.InsertOptions$;
import com.couchbase.client.scala.kv.LookupInOptions;
import com.couchbase.client.scala.kv.LookupInOptions$;
import com.couchbase.client.scala.kv.LookupInResult;
import com.couchbase.client.scala.kv.LookupInSpec;
import com.couchbase.client.scala.kv.MutateInOptions;
import com.couchbase.client.scala.kv.MutateInOptions$;
import com.couchbase.client.scala.kv.MutateInResult;
import com.couchbase.client.scala.kv.MutateInSpec;
import com.couchbase.client.scala.kv.MutationResult;
import com.couchbase.client.scala.kv.RemoveOptions;
import com.couchbase.client.scala.kv.RemoveOptions$;
import com.couchbase.client.scala.kv.ReplaceOptions;
import com.couchbase.client.scala.kv.ReplaceOptions$;
import com.couchbase.client.scala.kv.ScanOptions;
import com.couchbase.client.scala.kv.ScanOptions$;
import com.couchbase.client.scala.kv.ScanResult;
import com.couchbase.client.scala.kv.ScanType;
import com.couchbase.client.scala.kv.TouchOptions;
import com.couchbase.client.scala.kv.TouchOptions$;
import com.couchbase.client.scala.kv.UnlockOptions;
import com.couchbase.client.scala.kv.UnlockOptions$;
import com.couchbase.client.scala.kv.UpsertOptions;
import com.couchbase.client.scala.kv.UpsertOptions$;
import com.couchbase.client.scala.util.CoreCommonConverters$;
import com.couchbase.client.scala.util.ExpiryUtil$;
import com.couchbase.client.scala.util.FutureConversions$;
import java.io.Serializable;
import java.time.Instant;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class AsyncCollection
implements AsyncCollectionBase {
    private ExecutionContext ec;
    private Function1 kvTimeout;
    private Duration kvReadTimeout;
    private CollectionIdentifier collectionIdentifier;
    private CoreKeyspace keyspace;
    private CoreKvOps kvOps;
    private AsyncBinaryCollection binary;
    private final String name;
    private final String bucketName;
    private final String scopeName;
    private final CoreCouchbaseOps couchbaseOps;
    private final ClusterEnvironment environment;

    public AsyncCollection(String name, String bucketName, String scopeName, CoreCouchbaseOps couchbaseOps, ClusterEnvironment environment) {
        this.name = name;
        this.bucketName = bucketName;
        this.scopeName = scopeName;
        this.couchbaseOps = couchbaseOps;
        this.environment = environment;
        AsyncCollectionBase.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    public Function1 kvTimeout() {
        return this.kvTimeout;
    }

    @Override
    public Duration kvReadTimeout() {
        return this.kvReadTimeout;
    }

    @Override
    public CollectionIdentifier collectionIdentifier() {
        return this.collectionIdentifier;
    }

    @Override
    public CoreKeyspace keyspace() {
        return this.keyspace;
    }

    @Override
    public CoreKvOps kvOps() {
        return this.kvOps;
    }

    @Override
    public AsyncBinaryCollection binary() {
        return this.binary;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$ec_$eq(ExecutionContext x$0) {
        this.ec = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvTimeout_$eq(Function1 x$0) {
        this.kvTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvReadTimeout_$eq(Duration x$0) {
        this.kvReadTimeout = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$collectionIdentifier_$eq(CollectionIdentifier x$0) {
        this.collectionIdentifier = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$keyspace_$eq(CoreKeyspace x$0) {
        this.keyspace = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$kvOps_$eq(CoreKvOps x$0) {
        this.kvOps = x$0;
    }

    @Override
    public void com$couchbase$client$scala$AsyncCollectionBase$_setter_$binary_$eq(AsyncBinaryCollection x$0) {
        this.binary = x$0;
    }

    public String name() {
        return this.name;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public CoreCouchbaseOps couchbaseOps() {
        return this.couchbaseOps;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public <T> Future<MutationResult> insert(String id, T content, InsertOptions options, JsonSerializer<T> serializer) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.insert$$anonfun$1(options, id, serializer, content), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public <T> InsertOptions insert$default$3() {
        return InsertOptions$.MODULE$.Default();
    }

    public <T> Future<MutationResult> replace(String id, T content, ReplaceOptions options, JsonSerializer<T> serializer) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.replace$$anonfun$1(options, id, serializer, content), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public <T> ReplaceOptions replace$default$3() {
        return ReplaceOptions$.MODULE$.Default();
    }

    public <T> Future<MutationResult> upsert(String id, T content, UpsertOptions options, JsonSerializer<T> serializer) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.upsert$$anonfun$1(options, id, serializer, content), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public <T> UpsertOptions upsert$default$3() {
        return UpsertOptions$.MODULE$.Default();
    }

    public Future<MutationResult> remove(String id, RemoveOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.remove$$anonfun$1(options, id), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public RemoveOptions remove$default$2() {
        return RemoveOptions$.MODULE$.Default();
    }

    public Future<GetResult> get(String id, GetOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.get$$anonfun$1(options, id), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.environment(), options.transcoder()), this.ec());
    }

    public GetOptions get$default$2() {
        return GetOptions$.MODULE$.Default();
    }

    public Future<MutateInResult> mutateIn(String id, Seq<MutateInSpec> spec, MutateInOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.mutateIn$$anonfun$1(options, id, spec), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreSubdocMutateResult)result), this.ec());
    }

    public MutateInOptions mutateIn$default$3() {
        return MutateInOptions$.MODULE$.Default();
    }

    public Future<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.getAndLock$$anonfun$1(options, id, lockTime), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.environment(), options.transcoder()), this.ec());
    }

    public GetAndLockOptions getAndLock$default$3() {
        return GetAndLockOptions$.MODULE$.Default();
    }

    public Future<BoxedUnit> unlock(String id, long cas, UnlockOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.unlock$$anonfun$1(options, id, cas), this.ec()).map((Function1)(JProcedure1 & Serializable)_$1 -> {}, this.ec());
    }

    public UnlockOptions unlock$default$3() {
        return UnlockOptions$.MODULE$.Default();
    }

    public Future<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.getAndTouch$$anonfun$1(options, id, expiry), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreGetResult)result, this.environment(), options.transcoder()), this.ec());
    }

    public GetAndTouchOptions getAndTouch$default$3() {
        return GetAndTouchOptions$.MODULE$.Default();
    }

    public Future<LookupInResult> lookupIn(String id, Seq<LookupInSpec> spec, LookupInOptions options) {
        Duration duration = options.timeout();
        Duration.Infinite infinite = Duration$.MODULE$.MinusInf();
        Duration timeout = !(duration != null ? !duration.equals(infinite) : infinite != null) ? this.kvReadTimeout() : options.timeout();
        return this.getSubDoc(id, (Seq)spec, options.withExpiry(), timeout, (RetryStrategy)options.retryStrategy().getOrElse(this::lookupIn$$anonfun$1), (Transcoder)options.transcoder().getOrElse(this::lookupIn$$anonfun$2), (Option)options.parentSpan(), (Option)options.accessDeleted());
    }

    public LookupInOptions lookupIn$default$3() {
        return LookupInOptions$.MODULE$.Default();
    }

    public Future<ExistsResult> exists(String id, ExistsOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.exists$$anonfun$1(options, id), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreExistsResult)result), this.ec());
    }

    public ExistsOptions exists$default$2() {
        return ExistsOptions$.MODULE$.Default();
    }

    public Future<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        return CoreCommonConverters$.MODULE$.convert(() -> this.touch$$anonfun$1(options, id, expiry), this.ec()).map((Function1 & Serializable)result -> CoreCommonConverters$.MODULE$.convert((CoreMutationResult)result), this.ec());
    }

    public TouchOptions touch$default$3() {
        return TouchOptions$.MODULE$.Default();
    }

    public Future<Iterator<ScanResult>> scan(ScanType scanType, ScanOptions opts) {
        return FutureConversions$.MODULE$.javaCFToScalaFuture(this.scanRequest(scanType, opts).collectList().map(v -> CollectionConverters$.MODULE$.ListHasAsScala(v).asScala().iterator()).toFuture());
    }

    public ScanOptions scan$default$2() {
        return ScanOptions$.MODULE$.Default();
    }

    private final Transcoder insert$$anonfun$1$$anonfun$1() {
        return this.environment().transcoder();
    }

    private final CoreAsyncResponse insert$$anonfun$1(InsertOptions options$1, String id$1, JsonSerializer serializer$1, Object content$1) {
        return this.kvOps().insertAsync(CoreCommonConverters$.MODULE$.convert(options$1), id$1, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$1.transcoder().getOrElse(this::insert$$anonfun$1$$anonfun$1), serializer$1, content$1), CoreCommonConverters$.MODULE$.convert(options$1.durability()), ExpiryUtil$.MODULE$.expiryActual(options$1.expiry(), options$1.expiryTime()));
    }

    private final Transcoder replace$$anonfun$1$$anonfun$1() {
        return this.environment().transcoder();
    }

    private final CoreAsyncResponse replace$$anonfun$1(ReplaceOptions options$2, String id$2, JsonSerializer serializer$2, Object content$2) {
        return this.kvOps().replaceAsync(CoreCommonConverters$.MODULE$.convert(options$2), id$2, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$2.transcoder().getOrElse(this::replace$$anonfun$1$$anonfun$1), serializer$2, content$2), options$2.cas(), CoreCommonConverters$.MODULE$.convert(options$2.durability()), ExpiryUtil$.MODULE$.expiryActual(options$2.expiry(), options$2.expiryTime()), options$2.preserveExpiry());
    }

    private final Transcoder upsert$$anonfun$1$$anonfun$1() {
        return this.environment().transcoder();
    }

    private final CoreAsyncResponse upsert$$anonfun$1(UpsertOptions options$3, String id$3, JsonSerializer serializer$3, Object content$3) {
        return this.kvOps().upsertAsync(CoreCommonConverters$.MODULE$.convert(options$3), id$3, CoreCommonConverters$.MODULE$.encoder((Transcoder)options$3.transcoder().getOrElse(this::upsert$$anonfun$1$$anonfun$1), serializer$3, content$3), CoreCommonConverters$.MODULE$.convert(options$3.durability()), ExpiryUtil$.MODULE$.expiryActual(options$3.expiry(), options$3.expiryTime()), options$3.preserveExpiry());
    }

    private final CoreAsyncResponse remove$$anonfun$1(RemoveOptions options$4, String id$4) {
        return this.kvOps().removeAsync(CoreCommonConverters$.MODULE$.convert(options$4), id$4, options$4.cas(), CoreCommonConverters$.MODULE$.convert(options$4.durability()));
    }

    private final CoreAsyncResponse get$$anonfun$1(GetOptions options$5, String id$5) {
        return this.kvOps().getAsync(CoreCommonConverters$.MODULE$.convert(options$5), id$5, CollectionConverters$.MODULE$.SeqHasAsJava(options$5.project()).asJava(), options$5.withExpiry());
    }

    private final CoreAsyncResponse mutateIn$$anonfun$1(MutateInOptions options$7, String id$6, Seq spec$1) {
        return this.kvOps().subdocMutateAsync(CoreCommonConverters$.MODULE$.convert(options$7), id$6, () -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)spec$1.map((Function1 & Serializable)v -> v.convert())).asJava(), CoreCommonConverters$.MODULE$.convert(options$7.document()), options$7.cas(), CoreCommonConverters$.MODULE$.convert(options$7.durability()), ExpiryUtil$.MODULE$.expiryActual(options$7.expiry(), options$7.expiryTime()), options$7.preserveExpiry(), options$7.accessDeleted(), options$7.createAsDeleted());
    }

    private final CoreAsyncResponse getAndLock$$anonfun$1(GetAndLockOptions options$8, String id$7, Duration lockTime$1) {
        return this.kvOps().getAndLockAsync(CoreCommonConverters$.MODULE$.convert(options$8), id$7, CoreCommonConverters$.MODULE$.convert(lockTime$1));
    }

    private final CoreAsyncResponse unlock$$anonfun$1(UnlockOptions options$10, String id$8, long cas$1) {
        return this.kvOps().unlockAsync(CoreCommonConverters$.MODULE$.convert(options$10), id$8, cas$1);
    }

    private final CoreAsyncResponse getAndTouch$$anonfun$1(GetAndTouchOptions options$11, String id$9, Duration expiry$1) {
        return this.kvOps().getAndTouchAsync(CoreCommonConverters$.MODULE$.convert(options$11), id$9, CoreCommonConverters$.MODULE$.convertExpiry(expiry$1));
    }

    private final RetryStrategy lookupIn$$anonfun$1() {
        return this.environment().retryStrategy();
    }

    private final Transcoder lookupIn$$anonfun$2() {
        return this.environment().transcoder();
    }

    private final CoreAsyncResponse exists$$anonfun$1(ExistsOptions options$13, String id$10) {
        return this.kvOps().existsAsync(CoreCommonConverters$.MODULE$.convert(options$13), id$10);
    }

    private final CoreAsyncResponse touch$$anonfun$1(TouchOptions options$14, String id$11, Duration expiry$2) {
        return this.kvOps().touchAsync(CoreCommonConverters$.MODULE$.convert(options$14), id$11, ExpiryUtil$.MODULE$.expiryActual(expiry$2, (Option<Instant>)None$.MODULE$));
    }
}

