/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.opentelemetry;

import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryCounter;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryValueRecorder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.api.metrics.common.LabelsBuilder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OpenTelemetryMeter
implements Meter {
    private final io.opentelemetry.api.metrics.Meter otMeter;
    private final Map<NameAndTags, OpenTelemetryCounter> counters = new ConcurrentHashMap<NameAndTags, OpenTelemetryCounter>();
    private final Map<NameAndTags, OpenTelemetryValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, OpenTelemetryValueRecorder>();

    public static OpenTelemetryMeter wrap(io.opentelemetry.api.metrics.Meter otMeter) {
        return new OpenTelemetryMeter(otMeter);
    }

    private OpenTelemetryMeter(io.opentelemetry.api.metrics.Meter otMeter) {
        this.otMeter = otMeter;
    }

    public Counter counter(String name, Map<String, String> tags) {
        return this.counters.computeIfAbsent(new NameAndTags(name, tags), key -> {
            LongCounter counter = this.otMeter.longCounterBuilder(name).build();
            LabelsBuilder builder = Labels.builder();
            for (Map.Entry tag : tags.entrySet()) {
                builder.put((String)tag.getKey(), (String)tag.getValue());
            }
            return new OpenTelemetryCounter(counter.bind(builder.build()));
        });
    }

    public ValueRecorder valueRecorder(String name, Map<String, String> tags) {
        return this.valueRecorders.computeIfAbsent(new NameAndTags(name, tags), key -> {
            LongValueRecorder vc = this.otMeter.longValueRecorderBuilder(name).build();
            LabelsBuilder builder = Labels.builder();
            for (Map.Entry tag : tags.entrySet()) {
                builder.put((String)tag.getKey(), (String)tag.getValue());
            }
            return new OpenTelemetryValueRecorder(vc.bind(builder.build()));
        });
    }
}

