/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.micrometer;

import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.metrics.micrometer.MicrometerCounter;
import com.couchbase.client.metrics.micrometer.MicrometerValueRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MicrometerMeter
implements Meter {
    private final MeterRegistry meterRegistry;
    private final Map<NameAndTags, MicrometerCounter> counters = new ConcurrentHashMap<NameAndTags, MicrometerCounter>();
    private final Map<NameAndTags, MicrometerValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, MicrometerValueRecorder>();

    public static MicrometerMeter wrap(MeterRegistry meterRegistry) {
        return new MicrometerMeter(meterRegistry);
    }

    private MicrometerMeter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public Counter counter(String name, Map<String, String> tags) {
        return this.counters.computeIfAbsent(new NameAndTags(name, tags), key -> new MicrometerCounter(this.meterRegistry.counter(name, MicrometerMeter.convertTags(tags))));
    }

    public ValueRecorder valueRecorder(String name, Map<String, String> tags) {
        return this.valueRecorders.computeIfAbsent(new NameAndTags(name, tags), key -> new MicrometerValueRecorder(this.meterRegistry.summary(name, MicrometerMeter.convertTags(tags))));
    }

    private static Iterable<Tag> convertTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList());
    }
}

