/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.query.internal;

import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryProfile;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.codec.Content;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.couchbase.client.kotlin.codec.TypeRefKt;
import com.couchbase.client.kotlin.query.QueryParameters;
import com.couchbase.client.kotlin.query.QueryProfile;
import com.couchbase.client.kotlin.query.QueryScanConsistency;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\u001a\u00af\u0001\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"CoreQueryOptions", "Lcom/couchbase/client/core/api/query/CoreQueryOptions;", "common", "Lcom/couchbase/client/kotlin/CommonOptions;", "parameters", "Lcom/couchbase/client/kotlin/query/QueryParameters;", "preserveExpiry", "", "actualSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "consistency", "Lcom/couchbase/client/kotlin/query/QueryScanConsistency;", "readonly", "adhoc", "flexIndex", "metrics", "profile", "Lcom/couchbase/client/kotlin/query/QueryProfile;", "maxParallelism", "", "scanCap", "pipelineBatch", "pipelineCap", "clientContextId", "", "raw", "", "", "useReplica", "(Lcom/couchbase/client/kotlin/CommonOptions;Lcom/couchbase/client/kotlin/query/QueryParameters;ZLcom/couchbase/client/kotlin/codec/JsonSerializer;Lcom/couchbase/client/kotlin/query/QueryScanConsistency;ZZZZLcom/couchbase/client/kotlin/query/QueryProfile;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Boolean;)Lcom/couchbase/client/core/api/query/CoreQueryOptions;", "kotlin-client"})
public final class QueryExecutorKt {
    @NotNull
    public static final CoreQueryOptions CoreQueryOptions(@NotNull CommonOptions common, @NotNull QueryParameters parameters, boolean preserveExpiry, @NotNull JsonSerializer actualSerializer, @NotNull QueryScanConsistency consistency, boolean readonly, boolean adhoc, boolean flexIndex, boolean metrics2, @NotNull QueryProfile profile, @Nullable Integer maxParallelism, @Nullable Integer scanCap, @Nullable Integer pipelineBatch, @Nullable Integer pipelineCap, @Nullable String clientContextId, @NotNull Map<String, ? extends Object> raw, @Nullable Boolean useReplica) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)actualSerializer, (String)"actualSerializer");
        Intrinsics.checkNotNullParameter((Object)consistency, (String)"consistency");
        Intrinsics.checkNotNullParameter((Object)((Object)profile), (String)"profile");
        Intrinsics.checkNotNullParameter(raw, (String)"raw");
        return new CoreQueryOptions(adhoc, clientContextId, consistency, maxParallelism, metrics2, parameters, actualSerializer, pipelineBatch, pipelineCap, profile, raw, readonly, scanCap, flexIndex, preserveExpiry, common, useReplica){
            final /* synthetic */ boolean $adhoc;
            final /* synthetic */ String $clientContextId;
            final /* synthetic */ QueryScanConsistency $consistency;
            final /* synthetic */ Integer $maxParallelism;
            final /* synthetic */ boolean $metrics;
            final /* synthetic */ QueryParameters $parameters;
            final /* synthetic */ JsonSerializer $actualSerializer;
            final /* synthetic */ Integer $pipelineBatch;
            final /* synthetic */ Integer $pipelineCap;
            final /* synthetic */ QueryProfile $profile;
            final /* synthetic */ Map<String, Object> $raw;
            final /* synthetic */ boolean $readonly;
            final /* synthetic */ Integer $scanCap;
            final /* synthetic */ boolean $flexIndex;
            final /* synthetic */ boolean $preserveExpiry;
            final /* synthetic */ CommonOptions $common;
            final /* synthetic */ Boolean $useReplica;
            {
                this.$adhoc = $adhoc;
                this.$clientContextId = $clientContextId;
                this.$consistency = $consistency;
                this.$maxParallelism = $maxParallelism;
                this.$metrics = $metrics;
                this.$parameters = $parameters;
                this.$actualSerializer = $actualSerializer;
                this.$pipelineBatch = $pipelineBatch;
                this.$pipelineCap = $pipelineCap;
                this.$profile = $profile;
                this.$raw = $raw;
                this.$readonly = $readonly;
                this.$scanCap = $scanCap;
                this.$flexIndex = $flexIndex;
                this.$preserveExpiry = $preserveExpiry;
                this.$common = $common;
                this.$useReplica = $useReplica;
            }

            public boolean adhoc() {
                return this.$adhoc;
            }

            @Nullable
            public String clientContextId() {
                return this.$clientContextId;
            }

            @Nullable
            public CoreMutationState consistentWith() {
                QueryScanConsistency queryScanConsistency = this.$consistency;
                QueryScanConsistency.ConsistentWith consistentWith = queryScanConsistency instanceof QueryScanConsistency.ConsistentWith ? (QueryScanConsistency.ConsistentWith)queryScanConsistency : null;
                return consistentWith != null ? consistentWith.toCore() : null;
            }

            @Nullable
            public Integer maxParallelism() {
                return this.$maxParallelism;
            }

            public boolean metrics() {
                return this.$metrics;
            }

            @Nullable
            public ObjectNode namedParameters() {
                return this.$parameters.serializeIfNamed$kotlin_client(this.$actualSerializer);
            }

            @Nullable
            public ArrayNode positionalParameters() {
                return this.$parameters.serializeIfPositional$kotlin_client(this.$actualSerializer);
            }

            @Nullable
            public Integer pipelineBatch() {
                return this.$pipelineBatch;
            }

            @Nullable
            public Integer pipelineCap() {
                return this.$pipelineCap;
            }

            @NotNull
            public CoreQueryProfile profile() {
                return this.$profile.getCore$kotlin_client();
            }

            @Nullable
            public JsonNode raw() {
                TypeRef typeRef2;
                if (this.$raw.isEmpty()) {
                    return null;
                }
                boolean $i$f$typeRef = false;
                if (Map.class == Content.class) {
                    TypeRef typeRef3 = TypeRefKt.getContentTypeRef();
                    typeRef2 = typeRef3;
                    Intrinsics.checkNotNull(typeRef3, (String)"null cannot be cast to non-null type com.couchbase.client.kotlin.codec.TypeRef<T of com.couchbase.client.kotlin.codec.TypeRefKt.typeRef>");
                } else {
                    KType kType = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.nullableTypeOf(Object.class)));
                    typeRef2 = new TypeRef<Map<String, ? extends Object>>(kType){};
                }
                byte[] rawBytes = this.$actualSerializer.serialize(this.$raw, typeRef2);
                return Mapper.decodeIntoTree((byte[])rawBytes);
            }

            public boolean readonly() {
                return this.$readonly;
            }

            @Nullable
            public java.time.Duration scanWait() {
                java.time.Duration duration;
                Duration duration2 = this.$consistency.getScanWait-FghU774$kotlin_client();
                if (duration2 != null) {
                    long l = duration2.unbox-impl();
                    int n = Duration.getNanosecondsComponent-impl((long)l);
                    long l2 = Duration.getInWholeSeconds-impl((long)l);
                    java.time.Duration duration3 = java.time.Duration.ofSeconds(l2, n);
                    duration = duration3;
                    Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"toComponents-impl(...)");
                } else {
                    duration = null;
                }
                return duration;
            }

            @Nullable
            public Integer scanCap() {
                return this.$scanCap;
            }

            @Nullable
            public CoreQueryScanConsistency scanConsistency() {
                QueryScanConsistency queryScanConsistency = this.$consistency;
                return queryScanConsistency instanceof QueryScanConsistency.NotBounded ? CoreQueryScanConsistency.NOT_BOUNDED : (queryScanConsistency instanceof QueryScanConsistency.RequestPlus ? CoreQueryScanConsistency.REQUEST_PLUS : null);
            }

            public boolean flexIndex() {
                return this.$flexIndex;
            }

            @Nullable
            public Boolean preserveExpiry() {
                return this.$preserveExpiry ? Boolean.valueOf(true) : null;
            }

            @Nullable
            public CoreSingleQueryTransactionOptions asTransactionOptions() {
                return null;
            }

            @NotNull
            public CoreCommonOptions commonOptions() {
                return this.$common.toCore$kotlin_client();
            }

            @Nullable
            public Boolean useReplica() {
                return this.$useReplica;
            }
        };
    }
}

