/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0016\u00a2\u0006\u0002\u0010\rJ)\u0010\u000e\u001a\u00020\n\"\u0004\b\u0000\u0010\b2\u0006\u0010\u000f\u001a\u0002H\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fH\u0016\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/couchbase/client/kotlin/codec/JacksonJsonSerializer;", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;)V", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "deserialize", "T", "json", "", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "([BLcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "serialize", "value", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)[B", "kotlin-client"})
public final class JacksonJsonSerializer
implements JsonSerializer {
    @NotNull
    private final ObjectMapper mapper;

    public JacksonJsonSerializer(@NotNull ObjectMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    public JacksonJsonSerializer(@NotNull JsonMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this((ObjectMapper)mapper);
    }

    @Override
    @NotNull
    public <T> byte[] serialize(T value2, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        byte[] byArray = this.mapper.writeValueAsBytes(value2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"writeValueAsBytes(...)");
        return byArray;
    }

    @Override
    public <T> T deserialize(@NotNull byte[] json, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JavaType javaType = this.mapper.getTypeFactory().constructType(type.getType());
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
        JavaType javaType2 = javaType;
        Object result2 = this.mapper.readValue(json, javaType2);
        if (result2 == null && !type.getNullable()) {
            throw new NullPointerException("Can't deserialize null value into non-nullable type " + type);
        }
        return (T)result2;
    }
}

