/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.kotlin.annotations.VolatileCouchbaseApi;
import com.couchbase.client.kotlin.kv.ScanTerm;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VolatileCouchbaseApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/kv/ScanType;", "", "()V", "Companion", "Range", "Sample", "Lcom/couchbase/client/kotlin/kv/ScanType$Range;", "Lcom/couchbase/client/kotlin/kv/ScanType$Sample;", "kotlin-client"})
public abstract class ScanType {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private ScanType() {
    }

    public /* synthetic */ ScanType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/couchbase/client/kotlin/kv/ScanType$Range;", "Lcom/couchbase/client/kotlin/kv/ScanType;", "from", "Lcom/couchbase/client/kotlin/kv/ScanTerm;", "to", "(Lcom/couchbase/client/kotlin/kv/ScanTerm;Lcom/couchbase/client/kotlin/kv/ScanTerm;)V", "getFrom", "()Lcom/couchbase/client/kotlin/kv/ScanTerm;", "getTo", "kotlin-client"})
    public static final class Range
    extends ScanType {
        @NotNull
        private final ScanTerm from;
        @NotNull
        private final ScanTerm to;

        public Range(@NotNull ScanTerm from2, @NotNull ScanTerm to) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            super(null);
            this.from = from2;
            this.to = to;
        }

        @NotNull
        public final ScanTerm getFrom() {
            return this.from;
        }

        @NotNull
        public final ScanTerm getTo() {
            return this.to;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lcom/couchbase/client/kotlin/kv/ScanType$Sample;", "Lcom/couchbase/client/kotlin/kv/ScanType;", "limit", "", "seed", "(JLjava/lang/Long;)V", "getLimit", "()J", "getSeed", "()Ljava/lang/Long;", "Ljava/lang/Long;", "kotlin-client"})
    public static final class Sample
    extends ScanType {
        private final long limit;
        @Nullable
        private final Long seed;

        public Sample(long limit, @Nullable Long seed) {
            super(null);
            this.limit = limit;
            this.seed = seed;
            if (!(this.limit > 0L)) {
                boolean bl = false;
                String string = "Sample size limit must be > 0 but got " + this.limit;
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final long getLimit() {
            return this.limit;
        }

        @Nullable
        public final Long getSeed() {
            return this.seed;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0005J\u001a\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bJ\u001f\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/couchbase/client/kotlin/kv/ScanType$Companion;", "", "()V", "prefix", "Lcom/couchbase/client/kotlin/kv/ScanType$Range;", "", "range", "from", "Lcom/couchbase/client/kotlin/kv/ScanTerm;", "to", "sample", "Lcom/couchbase/client/kotlin/kv/ScanType$Sample;", "limit", "", "seed", "(JLjava/lang/Long;)Lcom/couchbase/client/kotlin/kv/ScanType$Sample;", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Range range(@NotNull ScanTerm from2, @NotNull ScanTerm to) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            return new Range(from2, to);
        }

        public static /* synthetic */ Range range$default(Companion companion, ScanTerm scanTerm, ScanTerm scanTerm2, int n, Object object) {
            if ((n & 1) != 0) {
                scanTerm = ScanTerm.Companion.getMinimum();
            }
            if ((n & 2) != 0) {
                scanTerm2 = ScanTerm.Companion.getMaximum();
            }
            return companion.range(scanTerm, scanTerm2);
        }

        @NotNull
        public final Range prefix(@NotNull String prefix2) {
            Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
            ScanTerm scanTerm = new ScanTerm(prefix2, false, 2, null);
            String string = prefix2;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new Range(scanTerm, new ScanTerm(ArraysKt.plus((byte[])byArray, (byte)-1), true));
        }

        @NotNull
        public final Sample sample(long limit, @Nullable Long seed) {
            return new Sample(limit, seed);
        }

        public static /* synthetic */ Sample sample$default(Companion companion, long l, Long l2, int n, Object object) {
            if ((n & 2) != 0) {
                l2 = null;
            }
            return companion.sample(l, l2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

