/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.query;

import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.kotlin.query.QueryFlowItem;
import com.couchbase.client.kotlin.query.QueryFlowItemKt;
import com.couchbase.client.kotlin.query.QueryMetrics;
import com.couchbase.client.kotlin.query.QueryStatus;
import com.couchbase.client.kotlin.query.QueryWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\bH\u0016R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR!\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lcom/couchbase/client/kotlin/query/QueryMetadata;", "Lcom/couchbase/client/kotlin/query/QueryFlowItem;", "header", "Lcom/couchbase/client/core/msg/query/QueryChunkHeader;", "trailer", "Lcom/couchbase/client/core/msg/query/QueryChunkTrailer;", "(Lcom/couchbase/client/core/msg/query/QueryChunkHeader;Lcom/couchbase/client/core/msg/query/QueryChunkTrailer;)V", "clientContextId", "", "getClientContextId", "()Ljava/lang/String;", "metrics", "Lcom/couchbase/client/kotlin/query/QueryMetrics;", "getMetrics", "()Lcom/couchbase/client/kotlin/query/QueryMetrics;", "profile", "", "", "getProfile", "()Ljava/util/Map;", "requestId", "getRequestId", "signature", "getSignature", "status", "Lcom/couchbase/client/kotlin/query/QueryStatus;", "getStatus", "()Lcom/couchbase/client/kotlin/query/QueryStatus;", "warnings", "", "Lcom/couchbase/client/kotlin/query/QueryWarning;", "getWarnings", "()Ljava/util/List;", "toString", "kotlin-client"})
public final class QueryMetadata
extends QueryFlowItem {
    @NotNull
    private final QueryChunkHeader header;
    @NotNull
    private final QueryChunkTrailer trailer;

    public QueryMetadata(@NotNull QueryChunkHeader header, @NotNull QueryChunkTrailer trailer) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)trailer, (String)"trailer");
        super(null);
        this.header = header;
        this.trailer = trailer;
    }

    @NotNull
    public final String getRequestId() {
        String string = this.header.requestId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.requestId()");
        return string;
    }

    @NotNull
    public final String getClientContextId() {
        String string = this.header.clientContextId().orElse("");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.clientContextId().orElse(\"\")");
        return string;
    }

    @NotNull
    public final QueryStatus getStatus() {
        String string = this.trailer.status();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trailer.status()");
        return QueryStatus.Companion.from(string);
    }

    @Nullable
    public final Map<String, Object> getSignature() {
        Optional optional = this.header.signature();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"header.signature()");
        return QueryFlowItemKt.access$parseAsMap(optional).orElse(null);
    }

    @Nullable
    public final Map<String, Object> getProfile() {
        Optional optional = this.trailer.profile();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"trailer.profile()");
        return QueryFlowItemKt.access$parseAsMap(optional).orElse(null);
    }

    @Nullable
    public final QueryMetrics getMetrics() {
        Optional optional = this.trailer.metrics();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"trailer.metrics()");
        return QueryFlowItemKt.access$parseAsMap(optional).map(QueryMetadata::_get_metrics_$lambda-0).orElse(null);
    }

    @NotNull
    public final List<QueryWarning> getWarnings() {
        List list = this.trailer.warnings().map(QueryMetadata::_get_warnings_$lambda-2).orElse(CollectionsKt.emptyList());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"trailer.warnings().map {\u2026    }.orElse(emptyList())");
        return list;
    }

    @NotNull
    public String toString() {
        return "QueryMetadata(requestId='" + this.getRequestId() + "', clientContextId='" + this.getClientContextId() + "', status=" + (Object)((Object)this.getStatus()) + ", signature=" + this.getSignature() + ", profile=" + this.getProfile() + ", metrics=" + this.getMetrics() + ", warnings=" + this.getWarnings() + ')';
    }

    private static final QueryMetrics _get_metrics_$lambda-0(Map it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new QueryMetrics(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final List _get_warnings_$lambda-2(byte[] warnings) {
        void $this$mapTo$iv$iv;
        List list = ErrorCodeAndMessage.fromJsonArray((byte[])warnings);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fromJsonArray(warnings)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ErrorCodeAndMessage errorCodeAndMessage = (ErrorCodeAndMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = it.code();
            String string = it.message();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.message()");
            QueryWarning queryWarning = new QueryWarning(n, string);
            collection.add(queryWarning);
        }
        return (List)destination$iv$iv;
    }
}

