/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.env;

import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.kotlin.CommonOptions;
import com.couchbase.client.kotlin.annotations.UncommittedCouchbaseApi;
import com.couchbase.client.kotlin.annotations.VolatileCouchbaseApi;
import com.couchbase.client.kotlin.codec.JacksonJsonSerializer;
import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.JsonTranscoder;
import com.couchbase.client.kotlin.codec.Transcoder;
import com.couchbase.client.kotlin.env.ClusterEnvironment;
import com.couchbase.client.kotlin.env.ClusterPropertyLoader;
import com.couchbase.client.kotlin.env.dsl.ClusterEnvironmentDslBuilder;
import com.couchbase.client.kotlin.internal.LangExtensionsKt;
import com.couchbase.client.kotlin.kv.Durability;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 02\u00020\u0001:\u0002/0B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u001b\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u00160\u0016*\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u0019\u0010\u001c\u001a\u00020\u0016*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0011\u0010 \u001a\u00020\u0016*\u00020\u001aH\u0000\u00a2\u0006\u0002\b!J\u0019\u0010\"\u001a\n \u0019*\u0004\u0018\u00010\u00160\u0016*\u00020\u001aH\u0000\u00a2\u0006\u0002\b#J\u0019\u0010$\u001a\n \u0019*\u0004\u0018\u00010%0%*\u00020\u001aH\u0000\u00a2\u0006\u0002\b&J!\u0010'\u001a\n \u0019*\u0004\u0018\u00010(0(*\u00020\u001a2\u0006\u0010)\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b*J\u0011\u0010+\u001a\u00020\u0016*\u00020\u001aH\u0000\u00a2\u0006\u0002\b,J\u0014\u0010-\u001a\u00020\u0016*\u00020.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "Lcom/couchbase/client/core/env/CoreEnvironment;", "builder", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "(Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;)V", "cryptoManager", "Lcom/couchbase/client/core/encryption/CryptoManager;", "getCryptoManager$kotlin_client", "()Lcom/couchbase/client/core/encryption/CryptoManager;", "jsonSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "getJsonSerializer$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "transcoder", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "getTranscoder$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/Transcoder;", "defaultAgentTitle", "", "shutdownSuspend", "", "timeout", "Ljava/time/Duration;", "(Ljava/time/Duration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "actualAnalyticsTimeout", "kotlin.jvm.PlatformType", "Lcom/couchbase/client/kotlin/CommonOptions;", "actualAnalyticsTimeout$kotlin_client", "actualKvTimeout", "durability", "Lcom/couchbase/client/kotlin/kv/Durability;", "actualKvTimeout$kotlin_client", "actualManagementTimeout", "actualManagementTimeout$kotlin_client", "actualQueryTimeout", "actualQueryTimeout$kotlin_client", "actualRetryStrategy", "Lcom/couchbase/client/core/retry/RetryStrategy;", "actualRetryStrategy$kotlin_client", "actualSpan", "Lcom/couchbase/client/core/cnc/RequestSpan;", "name", "actualSpan$kotlin_client", "actualViewTimeout", "actualViewTimeout$kotlin_client", "kvTimeout", "Lcom/couchbase/client/core/env/TimeoutConfig;", "Builder", "Companion", "kotlin-client"})
public final class ClusterEnvironment
extends CoreEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsonSerializer jsonSerializer;
    @NotNull
    private final Transcoder transcoder;
    @Nullable
    private final CryptoManager cryptoManager;

    private ClusterEnvironment(Builder builder2) {
        super((CoreEnvironment.Builder)builder2);
        this.cryptoManager = builder2.getCryptoManager$kotlin_client();
        Object object = builder2.getJsonSerializer$kotlin_client();
        this.jsonSerializer = object == null ? (JsonSerializer)new JacksonJsonSerializer(ExtensionsKt.jsonMapper((Function1)1.INSTANCE)) : object;
        object = builder2.getTranscoder$kotlin_client();
        this.transcoder = object == null ? (Transcoder)new JsonTranscoder(this.jsonSerializer) : object;
    }

    @NotNull
    public final JsonSerializer getJsonSerializer$kotlin_client() {
        return this.jsonSerializer;
    }

    @NotNull
    public final Transcoder getTranscoder$kotlin_client() {
        return this.transcoder;
    }

    @Nullable
    public final CryptoManager getCryptoManager$kotlin_client() {
        return this.cryptoManager;
    }

    @NotNull
    protected String defaultAgentTitle() {
        return "kotlin";
    }

    @Nullable
    public final Object shutdownSuspend(@NotNull Duration timeout, @NotNull Continuation<? super Unit> $completion) {
        Mono mono = this.shutdownReactive(timeout);
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"shutdownReactive(timeout)");
        Object object = LangExtensionsKt.await((Mono<Void>)mono, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public static /* synthetic */ Object shutdownSuspend$default(ClusterEnvironment clusterEnvironment, Duration duration, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = clusterEnvironment.timeoutConfig().disconnectTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"fun shutdownSuspend(time\u2026ve(timeout).await()\n    }");
            duration = duration2;
        }
        return clusterEnvironment.shutdownSuspend(duration, (Continuation<? super Unit>)continuation);
    }

    public final RetryStrategy actualRetryStrategy$kotlin_client(@NotNull CommonOptions $this$actualRetryStrategy) {
        Intrinsics.checkNotNullParameter((Object)$this$actualRetryStrategy, (String)"<this>");
        RetryStrategy retryStrategy = $this$actualRetryStrategy.getRetryStrategy();
        return retryStrategy == null ? this.retryStrategy() : retryStrategy;
    }

    public final RequestSpan actualSpan$kotlin_client(@NotNull CommonOptions $this$actualSpan, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$actualSpan, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.requestTracer().requestSpan(name, $this$actualSpan.getParentSpan());
    }

    @NotNull
    public final Duration actualViewTimeout$kotlin_client(@NotNull CommonOptions $this$actualViewTimeout) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)$this$actualViewTimeout, (String)"<this>");
        Duration duration2 = $this$actualViewTimeout.getTimeout();
        if (duration2 == null) {
            Duration duration3 = this.timeoutConfig().viewTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"timeoutConfig().viewTimeout()");
            duration = duration3;
        } else {
            duration = duration2;
        }
        return duration;
    }

    @NotNull
    public final Duration actualManagementTimeout$kotlin_client(@NotNull CommonOptions $this$actualManagementTimeout) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)$this$actualManagementTimeout, (String)"<this>");
        Duration duration2 = $this$actualManagementTimeout.getTimeout();
        if (duration2 == null) {
            Duration duration3 = this.timeoutConfig().managementTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"timeoutConfig().managementTimeout()");
            duration = duration3;
        } else {
            duration = duration2;
        }
        return duration;
    }

    public final Duration actualQueryTimeout$kotlin_client(@NotNull CommonOptions $this$actualQueryTimeout) {
        Intrinsics.checkNotNullParameter((Object)$this$actualQueryTimeout, (String)"<this>");
        Duration duration = $this$actualQueryTimeout.getTimeout();
        return duration == null ? this.timeoutConfig().queryTimeout() : duration;
    }

    public final Duration actualAnalyticsTimeout$kotlin_client(@NotNull CommonOptions $this$actualAnalyticsTimeout) {
        Intrinsics.checkNotNullParameter((Object)$this$actualAnalyticsTimeout, (String)"<this>");
        Duration duration = $this$actualAnalyticsTimeout.getTimeout();
        return duration == null ? this.timeoutConfig().analyticsTimeout() : duration;
    }

    @NotNull
    public final Duration actualKvTimeout$kotlin_client(@NotNull CommonOptions $this$actualKvTimeout, @NotNull Durability durability) {
        Duration duration;
        Intrinsics.checkNotNullParameter((Object)$this$actualKvTimeout, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)durability, (String)"durability");
        Duration duration2 = $this$actualKvTimeout.getTimeout();
        if (duration2 == null) {
            TimeoutConfig timeoutConfig = this.timeoutConfig();
            Intrinsics.checkNotNullExpressionValue((Object)timeoutConfig, (String)"timeoutConfig()");
            duration = this.kvTimeout(timeoutConfig, durability);
        } else {
            duration = duration2;
        }
        return duration;
    }

    private final Duration kvTimeout(TimeoutConfig $this$kvTimeout, Durability durability) {
        Duration duration;
        if (durability.isPersistent$kotlin_client()) {
            Duration duration2 = $this$kvTimeout.kvDurableTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"kvDurableTimeout()");
            duration = duration2;
        } else {
            Duration duration3 = $this$kvTimeout.kvTimeout();
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"kvTimeout()");
            duration = duration3;
        }
        return duration;
    }

    public /* synthetic */ ClusterEnvironment(Builder builder2, DefaultConstructorMarker $constructor_marker) {
        this(builder2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u001d\b\u0002\u0010\u0005\u001a\u0017\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Companion;", "", "()V", "builder", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "configBlock", "Lkotlin/Function1;", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentDslBuilder;", "", "Lcom/couchbase/client/kotlin/env/dsl/ClusterEnvironmentConfigBlock;", "Lkotlin/ExtensionFunctionType;", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Builder builder(@NotNull Function1<? super ClusterEnvironmentDslBuilder, Unit> configBlock) {
            Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
            ClusterEnvironmentDslBuilder builder2 = new ClusterEnvironmentDslBuilder();
            configBlock.invoke((Object)builder2);
            return builder2.toCore$kotlin_client();
        }

        public static /* synthetic */ Builder builder$default(Companion companion, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = builder.1.INSTANCE;
            }
            return companion.builder((Function1<? super ClusterEnvironmentDslBuilder, Unit>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u0003\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0017J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020\u00002\b\u0010\"\u001a\u0004\u0018\u00010#H\u0017J\u0012\u0010$\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010%H\u0017J\u0012\u0010&\u001a\u00020\u00002\b\u0010&\u001a\u0004\u0018\u00010'H\u0017J\u0010\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/couchbase/client/kotlin/env/ClusterEnvironment$Builder;", "Lcom/couchbase/client/core/env/CoreEnvironment$Builder;", "()V", "cryptoManager", "Lcom/couchbase/client/core/encryption/CryptoManager;", "getCryptoManager$kotlin_client", "()Lcom/couchbase/client/core/encryption/CryptoManager;", "setCryptoManager$kotlin_client", "(Lcom/couchbase/client/core/encryption/CryptoManager;)V", "jsonSerializer", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "getJsonSerializer$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "setJsonSerializer$kotlin_client", "(Lcom/couchbase/client/kotlin/codec/JsonSerializer;)V", "transcoder", "Lcom/couchbase/client/kotlin/codec/Transcoder;", "getTranscoder$kotlin_client", "()Lcom/couchbase/client/kotlin/codec/Transcoder;", "setTranscoder$kotlin_client", "(Lcom/couchbase/client/kotlin/codec/Transcoder;)V", "used", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getUsed$kotlin_client", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setUsed$kotlin_client", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "build", "Lcom/couchbase/client/kotlin/env/ClusterEnvironment;", "eventBus", "Lcom/couchbase/client/core/cnc/EventBus;", "load", "loader", "Lcom/couchbase/client/kotlin/env/ClusterPropertyLoader;", "meter", "Lcom/couchbase/client/core/cnc/Meter;", "requestTracer", "Lcom/couchbase/client/core/cnc/RequestTracer;", "scheduler", "Lreactor/core/scheduler/Scheduler;", "kotlin-client"})
    public static final class Builder
    extends CoreEnvironment.Builder<Builder> {
        @Nullable
        private JsonSerializer jsonSerializer;
        @Nullable
        private Transcoder transcoder;
        @Nullable
        private CryptoManager cryptoManager;
        @NotNull
        private AtomicBoolean used = new AtomicBoolean();

        @Nullable
        public final JsonSerializer getJsonSerializer$kotlin_client() {
            return this.jsonSerializer;
        }

        public final void setJsonSerializer$kotlin_client(@Nullable JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
        }

        @Nullable
        public final Transcoder getTranscoder$kotlin_client() {
            return this.transcoder;
        }

        public final void setTranscoder$kotlin_client(@Nullable Transcoder transcoder) {
            this.transcoder = transcoder;
        }

        @Nullable
        public final CryptoManager getCryptoManager$kotlin_client() {
            return this.cryptoManager;
        }

        public final void setCryptoManager$kotlin_client(@Nullable CryptoManager cryptoManager) {
            this.cryptoManager = cryptoManager;
        }

        @NotNull
        public final AtomicBoolean getUsed$kotlin_client() {
            return this.used;
        }

        public final void setUsed$kotlin_client(@NotNull AtomicBoolean atomicBoolean) {
            Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
            this.used = atomicBoolean;
        }

        @NotNull
        public final Builder load(@NotNull ClusterPropertyLoader loader) {
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            loader.load(this);
            return this;
        }

        @NotNull
        public final Builder jsonSerializer(@Nullable JsonSerializer jsonSerializer) {
            this.jsonSerializer = jsonSerializer;
            return this;
        }

        @NotNull
        public final Builder transcoder(@Nullable Transcoder transcoder) {
            this.transcoder = transcoder;
            return this;
        }

        @NotNull
        public final Builder cryptoManager(@Nullable CryptoManager cryptoManager) {
            this.cryptoManager = cryptoManager;
            return this;
        }

        @UncommittedCouchbaseApi
        @NotNull
        public Builder eventBus(@Nullable EventBus eventBus) {
            CoreEnvironment.Builder builder2 = super.eventBus(eventBus);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.eventBus(eventBus)");
            return (Builder)builder2;
        }

        @UncommittedCouchbaseApi
        @NotNull
        public Builder scheduler(@Nullable Scheduler scheduler) {
            CoreEnvironment.Builder builder2 = super.scheduler(scheduler);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.scheduler(scheduler)");
            return (Builder)builder2;
        }

        @VolatileCouchbaseApi
        @NotNull
        public Builder requestTracer(@Nullable RequestTracer requestTracer) {
            CoreEnvironment.Builder builder2 = super.requestTracer(requestTracer);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.requestTracer(requestTracer)");
            return (Builder)builder2;
        }

        @VolatileCouchbaseApi
        @NotNull
        public Builder meter(@Nullable Meter meter) {
            CoreEnvironment.Builder builder2 = super.meter(meter);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"super.meter(meter)");
            return (Builder)builder2;
        }

        @NotNull
        public ClusterEnvironment build() {
            boolean bl = this.used.compareAndSet(false, true);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "ClusterEnvironment.Builder.build() may only be called once.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new ClusterEnvironment(this, null);
        }
    }
}

