/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.kv;

import com.couchbase.client.kotlin.kv.ExpiryKt;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0004\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H \u00a2\u0006\u0002\b\u0005\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry;", "", "()V", "encode", "", "encode$kotlin_client", "Absolute", "Companion", "None", "Relative", "Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "kotlin-client"})
public abstract class Expiry {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private Expiry() {
    }

    public abstract long encode$kotlin_client();

    public /* synthetic */ Expiry(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$None;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "()V", "encode", "", "encode$kotlin_client", "toString", "", "kotlin-client"})
    public static final class None
    extends Expiry {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
            super(null);
        }

        @Override
        public long encode$kotlin_client() {
            return 0L;
        }

        @NotNull
        public String toString() {
            return "None";
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Absolute;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "instant", "Ljava/time/Instant;", "(Ljava/time/Instant;)V", "getInstant", "()Ljava/time/Instant;", "component1", "copy", "encode", "", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Absolute
    extends Expiry {
        @NotNull
        private final Instant instant;

        public Absolute(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            super(null);
            this.instant = instant;
            boolean bl = this.instant.compareTo(ExpiryKt.access$getEARLIEST_VALID_EXPIRY_INSTANT$p()) >= 0;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry instant " + this.getInstant() + " is in the distant past. Earliest valid expiry instant is " + ExpiryKt.access$getEARLIEST_VALID_EXPIRY_INSTANT$p());
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = this.instant.compareTo(ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p()) <= 0;
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry instant " + this.getInstant() + " is too far in the future. Latest valid expiry instant is " + ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p());
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Instant getInstant() {
            return this.instant;
        }

        @Override
        public long encode$kotlin_client() {
            return this.instant.getEpochSecond();
        }

        @NotNull
        public final Instant component1() {
            return this.instant;
        }

        @NotNull
        public final Absolute copy(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            return new Absolute(instant);
        }

        public static /* synthetic */ Absolute copy$default(Absolute absolute, Instant instant, int n, Object object) {
            if ((n & 1) != 0) {
                instant = absolute.instant;
            }
            return absolute.copy(instant);
        }

        @NotNull
        public String toString() {
            return "Absolute(instant=" + this.instant + ')';
        }

        public int hashCode() {
            return this.instant.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Absolute)) {
                return false;
            }
            Absolute absolute = (Absolute)other;
            return Intrinsics.areEqual((Object)this.instant, (Object)absolute.instant);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Relative;", "Lcom/couchbase/client/kotlin/kv/Expiry;", "duration", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "getDuration", "()Ljava/time/Duration;", "component1", "copy", "encode", "", "encode$kotlin_client", "equals", "", "other", "", "hashCode", "", "toString", "", "kotlin-client"})
    public static final class Relative
    extends Expiry {
        @NotNull
        private final Duration duration;

        public Relative(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            super(null);
            this.duration = duration;
            boolean bl = this.duration.getSeconds() > 0L;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry duration " + this.getDuration() + " is less than one second");
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = ExpiryKt.access$currentTimeSeconds() + this.duration.getSeconds() <= ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p().getEpochSecond();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = ExpiryKt.access$expiryErrorMessage("expiry duration " + this.getDuration() + " ends too far in the future. Latest valid expiry instant is " + ExpiryKt.access$getLATEST_VALID_EXPIRY_INSTANT$p());
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final Duration getDuration() {
            return this.duration;
        }

        @Override
        public long encode$kotlin_client() {
            long seconds = this.duration.getSeconds();
            return seconds < (long)ExpiryKt.access$getRELATIVE_EXPIRY_CUTOFF_SECONDS$p() ? seconds : ExpiryKt.access$currentTimeSeconds() + seconds;
        }

        @NotNull
        public final Duration component1() {
            return this.duration;
        }

        @NotNull
        public final Relative copy(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            return new Relative(duration);
        }

        public static /* synthetic */ Relative copy$default(Relative relative, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                duration = relative.duration;
            }
            return relative.copy(duration);
        }

        @NotNull
        public String toString() {
            return "Relative(duration=" + this.duration + ')';
        }

        public int hashCode() {
            return this.duration.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Relative)) {
                return false;
            }
            Relative relative = (Relative)other;
            return Intrinsics.areEqual((Object)this.duration, (Object)relative.duration);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\f\u00a8\u0006\u0013"}, d2={"Lcom/couchbase/client/kotlin/kv/Expiry$Companion;", "", "()V", "none", "Lcom/couchbase/client/kotlin/kv/Expiry;", "of", "duration", "Ljava/time/Duration;", "instant", "Ljava/time/Instant;", "ofDays", "days", "", "ofHours", "hours", "ofMinutes", "minutes", "ofSeconds", "seconds", "kotlin-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Expiry none() {
            return None.INSTANCE;
        }

        @NotNull
        public final Expiry of(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            return new Relative(duration);
        }

        @NotNull
        public final Expiry ofSeconds(long seconds) {
            Duration duration = Duration.ofSeconds(seconds);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(seconds)");
            return this.of(duration);
        }

        @NotNull
        public final Expiry ofMinutes(long minutes) {
            Duration duration = Duration.ofMinutes(minutes);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(minutes)");
            return this.of(duration);
        }

        @NotNull
        public final Expiry ofHours(long hours) {
            Duration duration = Duration.ofHours(hours);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(hours)");
            return this.of(duration);
        }

        @NotNull
        public final Expiry ofDays(long days) {
            Duration duration = Duration.ofDays(days);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(days)");
            return this.of(duration);
        }

        @NotNull
        public final Expiry of(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            return new Absolute(instant);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

