/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.codec;

import com.couchbase.client.kotlin.codec.JsonSerializer;
import com.couchbase.client.kotlin.codec.TypeRef;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.json.JsonMapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\b\"\u0004\b\u0000\u0010\u00062\u0006\u0010\r\u001a\u0002H\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/couchbase/client/kotlin/codec/JacksonJsonSerializer;", "Lcom/couchbase/client/kotlin/codec/JsonSerializer;", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "(Lcom/fasterxml/jackson/databind/json/JsonMapper;)V", "deserialize", "T", "json", "", "type", "Lcom/couchbase/client/kotlin/codec/TypeRef;", "([BLcom/couchbase/client/kotlin/codec/TypeRef;)Ljava/lang/Object;", "serialize", "value", "(Ljava/lang/Object;Lcom/couchbase/client/kotlin/codec/TypeRef;)[B", "kotlin-client"})
public final class JacksonJsonSerializer
implements JsonSerializer {
    @NotNull
    private final JsonMapper mapper;

    public JacksonJsonSerializer(@NotNull JsonMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    @Override
    @NotNull
    public <T> byte[] serialize(T value2, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        byte[] byArray = this.mapper.writeValueAsBytes(value2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"mapper.writeValueAsBytes(value)");
        return byArray;
    }

    @Override
    public <T> T deserialize(@NotNull byte[] json, @NotNull TypeRef<T> type) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        JavaType javaType = this.mapper.getTypeFactory().constructType(type.getType());
        Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"mapper.typeFactory.constructType(type.type)");
        JavaType javaType2 = javaType;
        Object result = this.mapper.readValue(json, javaType2);
        if (result == null && !type.getNullable()) {
            throw new NullPointerException(Intrinsics.stringPlus((String)"Can't deserialize null value into non-nullable type ", type));
        }
        return (T)result;
    }
}

