/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.kotlin.analytics;

import com.couchbase.client.core.util.Golang;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0013\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0018\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/couchbase/client/kotlin/analytics/AnalyticsMetrics;", "", "map", "", "", "(Ljava/util/Map;)V", "elapsedTime", "Ljava/time/Duration;", "getElapsedTime", "()Ljava/time/Duration;", "errorCount", "", "getErrorCount", "()J", "executionTime", "getExecutionTime", "getMap", "()Ljava/util/Map;", "processedObjects", "getProcessedObjects", "resultCount", "getResultCount", "resultSize", "getResultSize", "warningCount", "getWarningCount", "getDuration", "key", "getLong", "toString", "kotlin-client"})
public final class AnalyticsMetrics {
    @NotNull
    private final Map<String, Object> map;

    public AnalyticsMetrics(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        this.map = map2;
    }

    @NotNull
    public final Map<String, Object> getMap() {
        return this.map;
    }

    @NotNull
    public final Duration getElapsedTime() {
        return this.getDuration("elapsedTime");
    }

    @NotNull
    public final Duration getExecutionTime() {
        return this.getDuration("executionTime");
    }

    public final long getResultCount() {
        return this.getLong("resultCount");
    }

    public final long getResultSize() {
        return this.getLong("resultSize");
    }

    public final long getErrorCount() {
        return this.getLong("errorCount");
    }

    public final long getWarningCount() {
        return this.getLong("warningCount");
    }

    public final long getProcessedObjects() {
        return this.getLong("processedObjects");
    }

    private final Duration getDuration(String key) {
        String string = (String)this.map.get(key);
        Duration duration = Golang.parseDuration((String)(string == null ? "0" : string));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parseDuration(map[key] as String? ?: \"0\")");
        return duration;
    }

    private final long getLong(String key) {
        Number number = (Number)this.map.get(key);
        return (number == null ? (Number)0 : (Number)number).longValue();
    }

    @NotNull
    public String toString() {
        return "AnalyticsMetrics(map=" + this.map + ')';
    }
}

