/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.collection;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.collection.AsyncCollectionManager;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.CreateCollectionOptions;
import com.couchbase.client.java.manager.collection.CreateCollectionSettings;
import com.couchbase.client.java.manager.collection.CreateScopeOptions;
import com.couchbase.client.java.manager.collection.DropCollectionOptions;
import com.couchbase.client.java.manager.collection.DropScopeOptions;
import com.couchbase.client.java.manager.collection.GetAllScopesOptions;
import com.couchbase.client.java.manager.collection.GetScopeOptions;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.couchbase.client.java.manager.collection.UpdateCollectionOptions;
import com.couchbase.client.java.manager.collection.UpdateCollectionSettings;
import java.util.List;

@Stability.Volatile
public class CollectionManager {
    private final AsyncCollectionManager asyncCollectionManager;

    @Stability.Internal
    public CollectionManager(AsyncCollectionManager async) {
        this.asyncCollectionManager = async;
    }

    @Deprecated
    public void createCollection(CollectionSpec collectionSpec) {
        this.createCollection(collectionSpec, CreateCollectionOptions.createCollectionOptions());
    }

    @Deprecated
    public void createCollection(CollectionSpec collectionSpec, CreateCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.createCollection(collectionSpec, options));
    }

    @Stability.Volatile
    public void createCollection(String scopeName, String collectionName) {
        this.createCollection(scopeName, collectionName, CreateCollectionSettings.createCollectionSettings(), CreateCollectionOptions.createCollectionOptions());
    }

    @Stability.Volatile
    public void createCollection(String scopeName, String collectionName, CreateCollectionSettings settings) {
        AsyncUtils.block(this.asyncCollectionManager.createCollection(scopeName, collectionName, settings));
    }

    @Stability.Volatile
    public void createCollection(String scopeName, String collectionName, CreateCollectionSettings settings, CreateCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.createCollection(scopeName, collectionName, settings, options));
    }

    public void createScope(String scopeName) {
        this.createScope(scopeName, CreateScopeOptions.createScopeOptions());
    }

    public void createScope(String scopeName, CreateScopeOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.createScope(scopeName, options));
    }

    @Stability.Volatile
    public void updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings) {
        AsyncUtils.block(this.asyncCollectionManager.updateCollection(scopeName, collectionName, settings));
    }

    @Stability.Volatile
    public void updateCollection(String scopeName, String collectionName, UpdateCollectionSettings settings, UpdateCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.updateCollection(scopeName, collectionName, settings, options));
    }

    @Deprecated
    public void dropCollection(CollectionSpec collectionSpec) {
        this.dropCollection(collectionSpec, DropCollectionOptions.dropCollectionOptions());
    }

    @Deprecated
    public void dropCollection(CollectionSpec collectionSpec, DropCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.dropCollection(collectionSpec, options));
    }

    @Stability.Volatile
    public void dropCollection(String scopeName, String collectionName) {
        this.dropCollection(scopeName, collectionName, DropCollectionOptions.dropCollectionOptions());
    }

    @Stability.Volatile
    public void dropCollection(String scopeName, String collectionName, DropCollectionOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.dropCollection(scopeName, collectionName, options));
    }

    public void dropScope(String scopeName) {
        this.dropScope(scopeName, DropScopeOptions.dropScopeOptions());
    }

    public void dropScope(String scopeName, DropScopeOptions options) {
        AsyncUtils.block(this.asyncCollectionManager.dropScope(scopeName, options));
    }

    @Deprecated
    public ScopeSpec getScope(String scopeName) {
        return this.getScope(scopeName, GetScopeOptions.getScopeOptions());
    }

    @Deprecated
    public ScopeSpec getScope(String scopeName, GetScopeOptions options) {
        return AsyncUtils.block(this.asyncCollectionManager.getScope(scopeName, options));
    }

    public List<ScopeSpec> getAllScopes() {
        return this.getAllScopes(GetAllScopesOptions.getAllScopesOptions());
    }

    public List<ScopeSpec> getAllScopes(GetAllScopesOptions options) {
        return AsyncUtils.block(this.asyncCollectionManager.getAllScopes(options));
    }
}

