/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.manager.view.AsyncViewIndexManager;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.DropDesignDocumentOptions;
import com.couchbase.client.java.manager.view.GetAllDesignDocumentsOptions;
import com.couchbase.client.java.manager.view.GetDesignDocumentOptions;
import com.couchbase.client.java.manager.view.PublishDesignDocumentOptions;
import com.couchbase.client.java.manager.view.UpsertDesignDocumentOptions;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveViewIndexManager {
    private final AsyncViewIndexManager async;
    private final ReactorOps reactor;

    public ReactiveViewIndexManager(ReactorOps reactor, AsyncViewIndexManager async) {
        this.reactor = Objects.requireNonNull(reactor);
        this.async = Objects.requireNonNull(async);
    }

    public Mono<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getDesignDocument(name, namespace));
    }

    public Mono<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace, GetDesignDocumentOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getDesignDocument(name, namespace, options));
    }

    public Mono<Void> upsertDesignDocument(DesignDocument designDocument, DesignDocumentNamespace namespace) {
        return this.reactor.publishOnUserScheduler(() -> this.async.upsertDesignDocument(designDocument, namespace));
    }

    public Mono<Void> upsertDesignDocument(DesignDocument designDocument, DesignDocumentNamespace namespace, UpsertDesignDocumentOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.upsertDesignDocument(designDocument, namespace, options));
    }

    public Mono<Void> publishDesignDocument(String name) {
        return this.reactor.publishOnUserScheduler(() -> this.async.publishDesignDocument(name));
    }

    public Mono<Void> publishDesignDocument(String name, PublishDesignDocumentOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.publishDesignDocument(name, options));
    }

    public Mono<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDesignDocument(name, namespace));
    }

    public Mono<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace, DropDesignDocumentOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDesignDocument(name, namespace, options));
    }

    public Flux<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllDesignDocuments(namespace)));
    }

    public Flux<DesignDocument> getAllDesignDocuments(DesignDocumentNamespace namespace, GetAllDesignDocumentsOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllDesignDocuments(namespace, options)));
    }
}

