/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.java.json.JacksonTransformers;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryStatus;
import com.couchbase.client.java.query.QueryWarning;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QueryMetaData {
    CoreQueryMetaData internal;

    @Stability.Internal
    public QueryMetaData(CoreQueryMetaData internal) {
        this.internal = internal;
    }

    public String requestId() {
        return this.internal.requestId();
    }

    public String clientContextId() {
        return this.internal.clientContextId();
    }

    public QueryStatus status() {
        return QueryStatus.from(this.internal.status().name());
    }

    public Optional<JsonObject> signature() {
        return this.signatureBytes().map(v -> {
            try {
                return (JsonObject)JacksonTransformers.MAPPER.readValue(v, JsonObject.class);
            }
            catch (IOException ex) {
                throw new DecodingFailureException((Throwable)ex);
            }
        });
    }

    @Stability.Uncommitted
    public Optional<byte[]> signatureBytes() {
        return this.internal.signature();
    }

    public Optional<JsonObject> profile() {
        return this.internal.profile().map(v -> {
            try {
                return (JsonObject)JacksonTransformers.MAPPER.readValue(v, JsonObject.class);
            }
            catch (IOException ex) {
                throw new DecodingFailureException((Throwable)ex);
            }
        });
    }

    public Optional<byte[]> profileBytes() {
        return this.internal.profile();
    }

    public Optional<QueryMetrics> metrics() {
        return this.internal.metrics().map(QueryMetrics::new);
    }

    public List<QueryWarning> warnings() {
        return this.internal.warnings().stream().map(v -> new QueryWarning(v.inner())).collect(Collectors.toList());
    }
}

