/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.Transcoder;
import java.nio.charset.StandardCharsets;

public class RawStringTranscoder
implements Transcoder {
    public static RawStringTranscoder INSTANCE = new RawStringTranscoder();

    private RawStringTranscoder() {
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        if (input instanceof CommonOptions.BuiltCommonOptions || input instanceof CommonOptions) {
            throw InvalidArgumentException.fromMessage((String)("No content provided, cannot encode " + input.getClass().getSimpleName() + " as content!"));
        }
        if (input instanceof String) {
            return new Transcoder.EncodedValue(((String)input).getBytes(StandardCharsets.UTF_8), CodecFlags.STRING_COMPAT_FLAGS);
        }
        throw InvalidArgumentException.fromMessage((String)"Only String is supported for the RawStringTranscoder!");
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        if (target.equals(String.class)) {
            return (T)new String(input, StandardCharsets.UTF_8);
        }
        throw new DecodingFailureException("RawStringTranscoder can only decode into String!");
    }
}

