/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics.link;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLinkType;
import java.util.Map;
import java.util.Optional;

@Stability.Volatile
public class RawExternalAnalyticsLink
extends AnalyticsLink {
    private final AnalyticsLinkType type;
    private final String json;

    @JsonCreator
    public static RawExternalAnalyticsLink fromJson(ObjectNode json) {
        return new RawExternalAnalyticsLink(json);
    }

    private RawExternalAnalyticsLink(ObjectNode json) {
        super(json.path("name").asText(), Optional.ofNullable(json.path("dataverse").textValue()).orElse(json.path("scope").asText()));
        this.json = json.toString();
        this.type = AnalyticsLinkType.of(json.path("type").textValue());
    }

    @Override
    public Map<String, String> toMap() {
        throw new UnsupportedOperationException("This version of the Couchbase SDK does not know how to update analytics links of type '" + this.type + "'.");
    }

    @Override
    public AnalyticsLinkType type() {
        return this.type;
    }

    public String json() {
        return this.json;
    }

    public String toString() {
        return "RawExternalAnalyticsLink{type=" + this.type() + ", dataverse='" + RedactableArgument.redactMeta((Object)this.dataverse()) + '\'' + ", name='" + RedactableArgument.redactMeta((Object)this.name()) + '\'' + '}';
    }
}

