/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.Golang;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.analytics.AnalyticsScanConsistency;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class AnalyticsOptions
extends CommonOptions<AnalyticsOptions> {
    private String clientContextId;
    private JsonObject namedParameters;
    private JsonArray positionalParameters;
    private int priority;
    private Map<String, Object> raw;
    private boolean readonly = false;
    private AnalyticsScanConsistency scanConsistency;
    private String scanWait;
    private JsonSerializer serializer;

    private AnalyticsOptions() {
    }

    public static AnalyticsOptions analyticsOptions() {
        return new AnalyticsOptions();
    }

    public AnalyticsOptions priority(boolean priority) {
        this.priority = priority ? -1 : 0;
        return this;
    }

    public AnalyticsOptions clientContextId(String clientContextId) {
        this.clientContextId = clientContextId == null || clientContextId.isEmpty() ? null : clientContextId;
        return this;
    }

    public AnalyticsOptions readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public AnalyticsOptions serializer(JsonSerializer serializer) {
        Validators.notNull((Object)serializer, (String)"JsonSerializer");
        this.serializer = serializer;
        return this;
    }

    public AnalyticsOptions scanConsistency(AnalyticsScanConsistency scanConsistency) {
        Validators.notNull((Object)((Object)scanConsistency), (String)"AnalyticsScanConsistency");
        this.scanConsistency = scanConsistency;
        return this;
    }

    @Stability.Uncommitted
    public AnalyticsOptions scanWait(Duration wait) {
        this.scanWait = Golang.encodeDurationToMs((Duration)((Duration)Validators.notNull((Object)wait, (String)"Wait Duration")));
        return this;
    }

    public AnalyticsOptions parameters(JsonObject named) {
        Validators.notNull((Object)named, (String)"Named Parameters");
        this.namedParameters = named;
        this.positionalParameters = null;
        return this;
    }

    public AnalyticsOptions parameters(JsonArray positional) {
        Validators.notNull((Object)positional, (String)"Positional Parameters");
        this.positionalParameters = positional;
        this.namedParameters = null;
        return this;
    }

    public AnalyticsOptions raw(String key, Object value) {
        Validators.notNullOrEmpty((String)key, (String)"Key");
        if (this.raw == null) {
            this.raw = new HashMap<String, Object>();
        }
        this.raw.put(key, value);
        return this;
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    @Stability.Internal
    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(AnalyticsOptions.this);
        }

        public boolean readonly() {
            return AnalyticsOptions.this.readonly;
        }

        public JsonSerializer serializer() {
            return AnalyticsOptions.this.serializer;
        }

        public int priority() {
            return AnalyticsOptions.this.priority;
        }

        public void injectParams(JsonObject input) {
            boolean positionalPresent;
            input.put("client_context_id", AnalyticsOptions.this.clientContextId == null ? UUID.randomUUID().toString() : AnalyticsOptions.this.clientContextId);
            if (AnalyticsOptions.this.scanConsistency != null) {
                input.put("scan_consistency", AnalyticsOptions.this.scanConsistency.toString());
            }
            if (AnalyticsOptions.this.scanWait != null && !AnalyticsOptions.this.scanWait.isEmpty() && AnalyticsOptions.this.scanConsistency != null && AnalyticsScanConsistency.NOT_BOUNDED != AnalyticsOptions.this.scanConsistency) {
                input.put("scan_wait", AnalyticsOptions.this.scanWait);
            }
            boolean bl = positionalPresent = AnalyticsOptions.this.positionalParameters != null && !AnalyticsOptions.this.positionalParameters.isEmpty();
            if (AnalyticsOptions.this.namedParameters != null && !AnalyticsOptions.this.namedParameters.isEmpty()) {
                AnalyticsOptions.this.namedParameters.getNames().forEach(key -> {
                    Object value = AnalyticsOptions.this.namedParameters.get((String)key);
                    if (key.charAt(0) != '$') {
                        input.put('$' + key, value);
                    } else {
                        input.put((String)key, value);
                    }
                });
            }
            if (positionalPresent) {
                input.put("args", AnalyticsOptions.this.positionalParameters);
            }
            if (AnalyticsOptions.this.readonly) {
                input.put("readonly", true);
            }
            if (AnalyticsOptions.this.raw != null) {
                for (Map.Entry entry : AnalyticsOptions.this.raw.entrySet()) {
                    input.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

