/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.raw;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RawManagerOptions
extends CommonOptions<RawManagerOptions> {
    private Map<String, Object> httpHeaders;
    private JsonSerializer serializer;

    public static RawManagerOptions rawManagerOptions() {
        return new RawManagerOptions();
    }

    public RawManagerOptions serializer(JsonSerializer serializer) {
        Validators.notNull((Object)serializer, (String)"Serializer");
        this.serializer = serializer;
        return this;
    }

    public RawManagerOptions httpHeader(String name, Object value) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new HashMap<String, Object>();
        }
        this.httpHeaders.put(name, value);
        return this;
    }

    private RawManagerOptions() {
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(RawManagerOptions.this);
        }

        public JsonSerializer serializer() {
            return RawManagerOptions.this.serializer;
        }

        public Map<String, Object> httpHeaders() {
            return RawManagerOptions.this.httpHeaders == null ? Collections.emptyMap() : RawManagerOptions.this.httpHeaders;
        }
    }
}

