/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.Keyring;
import java.util.Objects;
import java.util.Optional;

public abstract class RotatingKeyring
implements Keyring {
    protected final String versionDelimiter;

    protected RotatingKeyring(String versionDelimiter) {
        this.versionDelimiter = Objects.requireNonNull(versionDelimiter);
    }

    @Override
    public Optional<Keyring.Key> get(String keyId) {
        KeyNameAndVersion nameAndVersion = this.parseKeyNameAndVersion(keyId);
        return this.getKeyBytes(nameAndVersion).map(bytes -> Keyring.Key.create(nameAndVersion.format(), bytes));
    }

    protected abstract String getPrimaryVersion(String var1);

    protected abstract Optional<byte[]> getKeyBytes(KeyNameAndVersion var1);

    protected KeyNameAndVersion parseKeyNameAndVersion(String keyId) {
        int i = keyId.indexOf(this.versionDelimiter);
        return i == -1 ? new KeyNameAndVersion(keyId, this.getPrimaryVersion(keyId)) : new KeyNameAndVersion(keyId.substring(0, i), keyId.substring(i + this.versionDelimiter.length()));
    }

    protected class KeyNameAndVersion {
        private final String name;
        private final String version;

        public KeyNameAndVersion(String name, String version) {
            this.name = Objects.requireNonNull(name);
            this.version = Objects.requireNonNull(version);
        }

        public String name() {
            return this.name;
        }

        public String version() {
            return this.version;
        }

        public String format() {
            return this.name + RotatingKeyring.this.versionDelimiter + this.version;
        }

        public String toString() {
            return this.format();
        }
    }
}

