/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.encryption.Decrypter;
import com.couchbase.client.encryption.EncryptionResult;
import com.couchbase.client.encryption.Keyring;
import com.couchbase.client.encryption.errors.CryptoKeyNotFoundException;
import com.couchbase.client.encryption.internal.Zeroizer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

@Stability.Internal
public class LegacyRsaDecrypter
implements Decrypter {
    private final Function<String, String> publicKeyNameToPrivateKeyName;
    private final Keyring keyring;

    public LegacyRsaDecrypter(Keyring keyring, Function<String, String> publicKeyNameToPrivateKeyName) {
        this.keyring = Objects.requireNonNull(keyring);
        this.publicKeyNameToPrivateKeyName = Objects.requireNonNull(publicKeyNameToPrivateKeyName);
    }

    @Override
    public String algorithm() {
        return "RSA-2048-OAEP-SHA1";
    }

    @Override
    public byte[] decrypt(EncryptionResult encrypted) throws Exception {
        String kid = encrypted.getString("kid");
        byte[] ciphertext = encrypted.getBytes("ciphertext");
        OAEPParameterSpec oaepParams = new OAEPParameterSpec("SHA-1", "MGF1", new MGF1ParameterSpec("SHA-1"), PSource.PSpecified.DEFAULT);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(2, (Key)this.getPrivateKey(kid), oaepParams);
        return cipher.doFinal(ciphertext);
    }

    private String getPrivateKeyName(String publicKeyName) {
        return Optional.of(this.publicKeyNameToPrivateKeyName.apply(publicKeyName)).orElseThrow(() -> new CryptoKeyNotFoundException("No mapping to private key name found for public key '" + publicKeyName + "'"));
    }

    private RSAPrivateKey getPrivateKey(String publicKeyName) throws Exception {
        try (Zeroizer zeroizer = new Zeroizer();){
            String privateKeyName = this.getPrivateKeyName(publicKeyName);
            byte[] keyBytes = zeroizer.add(this.keyring.getOrThrow(privateKeyName).bytes());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(keyBytes);
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)keyFactory.generatePrivate(privateKeySpec);
            return rSAPrivateKey;
        }
    }
}

