/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.codec;

import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.codec.TypeRef;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;

public final class JacksonDeserializer
implements Deserializer {
    private final ObjectMapper mapper;

    public JacksonDeserializer(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) throws IOException {
        return (T)this.mapper.readValue(input, target);
    }

    @Override
    public <T> T deserialize(TypeRef<T> target, byte[] input) throws IOException {
        JavaType type = this.mapper.getTypeFactory().constructType(target.type());
        return (T)this.mapper.readValue(input, type);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

