/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.internal;

import com.couchbase.client.core.env.SecurityConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Certificates {
    private Certificates() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static List<X509Certificate> parse(String pemCertificates) {
        return Certificates.read(new ByteArrayInputStream(pemCertificates.getBytes(StandardCharsets.UTF_8)));
    }

    public static List<X509Certificate> read(InputStream pemStream) {
        return Certificates.decodeCertificates(pemStream);
    }

    public static List<X509Certificate> read(Path pemFilePath) {
        List<X509Certificate> list;
        block9: {
            InputStream is = Files.newInputStream(pemFilePath, new OpenOption[0]);
            try {
                list = Certificates.decodeCertificates(is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to read certificates from file \"" + pemFilePath + "\"", e);
                }
            }
            is.close();
        }
        return list;
    }

    public static List<X509Certificate> getJvmCertificates() {
        return SecurityConfig.jvmCaCertificates();
    }

    public static List<X509Certificate> getCapellaCertificates() {
        return SecurityConfig.capellaCaCertificates();
    }

    public static List<X509Certificate> getNonProdCertificates() {
        return Certificates.parse("-----BEGIN CERTIFICATE-----\nMIIDFTCCAf2gAwIBAgIRANguFcFZ7eVLTF2mnPqkkhYwDQYJKoZIhvcNAQELBQAw\nJDESMBAGA1UECgwJQ291Y2hiYXNlMQ4wDAYDVQQLDAVDbG91ZDAeFw0xOTEwMTgx\nNDUzMzRaFw0yOTEwMTgxNTUzMzRaMCQxEjAQBgNVBAoMCUNvdWNoYmFzZTEOMAwG\nA1UECwwFQ2xvdWQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDMoL2G\n1yR4XKOL5KrAZbgJI11NkcooxqCSqoibr5nSM+GNARlou42XbopRhkLQlSMlmH7U\nZreI7xq2MqmCaQvP1jdS5al/GwuwAP+2kU2nz4IHzliCVV6YvYqNy0fygNpYky9/\nwjCu32n8Ae0AZuxcsAzPUtJBvIIGHum08WlLYS3gNrYkfyds6LfvZvqMk703RL5X\nNy/RXWmbbBXAXh0chsavEK7EsDLI4t4WI2Iv8+lwS7Wo7Vh6NnEmJLPAAp7udNK4\nU3nwjkL5p/yINROT7CxUE9x0IB2l2rZwZiJhgHCpee77J8QesDut+jZu38ZYY3le\nPS38S81T6I6bSSgtAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wHQYDVR0OBBYE\nFLlocLdzgAeibrlCmEO4OH5Buf3vMA4GA1UdDwEB/wQEAwIBhjANBgkqhkiG9w0B\nAQsFAAOCAQEAkoVX5CJ7rGx2ALfzy5C7Z+tmEmrZ6jdHjDtw4XwWNhlrsgMuuboU\nY9XMinSSm1TVfvIz4ru82MVMRxq4v1tPwPdZabbzKYclHkwSMxK5BkyEKWzF1Hoq\nUcinTaT68lVzkTc0D8T+gkRzwXIqxjML2ZdruD1foHNzCgeGHzKzdsjYqrnHv17b\nJ+f5tqoa5CKbnyWl3HP0k7r3HHQP0GQequoqXcL3XlERX3Ne20Chck9mftNnHhKw\nDby7ylZaP97sphqOZQ/W/gza7x1JYylrLXvjfdv3Nmu7oSMKO/2cDyWwcbVGkpbk\n8JOQtFENWmr9u2S0cQfwoCSYBWaK0ofivA==\n-----END CERTIFICATE-----\n");
    }

    private static List<X509Certificate> decodeCertificates(InputStream pem) {
        Objects.requireNonNull(pem);
        try {
            return (List)Certificates.getX509CertificateFactory().generateCertificates(pem);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException("Failed to decode certificates", e);
        }
    }

    private static CertificateFactory getX509CertificateFactory() {
        try {
            return CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not instantiate X.509 CertificateFactory", e);
        }
    }

    private static TrustManagerFactory getDefaultTrustManagerFactory() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            return tmf;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream getResource(String resourceName) {
        InputStream inputStream;
        block9: {
            InputStream is = SecurityConfig.class.getResourceAsStream(resourceName);
            try {
                if (is == null) {
                    throw new RuntimeException("Missing resource: " + resourceName);
                }
                inputStream = is;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return inputStream;
    }
}

