/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Golang;
import com.couchbase.columnar.client.java.QueryPriority;
import com.couchbase.columnar.client.java.ScanConsistency;
import com.couchbase.columnar.client.java.codec.Deserializer;
import com.couchbase.columnar.client.java.internal.InternalJacksonSerDes;
import com.couchbase.columnar.client.java.internal.JacksonTransformers;
import com.couchbase.columnar.client.java.internal.JsonSerializer;
import com.couchbase.columnar.client.java.json.JsonArray;
import com.couchbase.columnar.client.java.json.JsonObject;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;

public final class QueryOptions {
    private @Nullable Duration timeout;
    private @Nullable String clientContextId;
    private @Nullable Map<String, ?> namedParameters;
    private @Nullable List<?> positionalParameters;
    private @Nullable QueryPriority priority;
    private @Nullable ScanConsistency scanConsistency;
    private @Nullable Duration scanWait;
    private @Nullable Deserializer deserializer;
    private @Nullable Boolean readOnly;
    private @Nullable Map<String, ?> raw;

    QueryOptions() {
    }

    public QueryOptions timeout(@Nullable Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public QueryOptions parameters(@Nullable Map<String, ?> namedParameters) {
        this.namedParameters = namedParameters == null ? null : Collections.unmodifiableMap(new HashMap(namedParameters));
        return this;
    }

    public QueryOptions parameters(@Nullable List<?> positionalParameters) {
        this.positionalParameters = positionalParameters == null ? null : Collections.unmodifiableList(new ArrayList(positionalParameters));
        return this;
    }

    public QueryOptions deserializer(@Nullable Deserializer deserializer) {
        this.deserializer = deserializer;
        return this;
    }

    public QueryOptions scanWait(@Nullable Duration scanWait) {
        this.scanWait = scanWait;
        return this;
    }

    public QueryOptions priority(@Nullable QueryPriority priority) {
        this.priority = priority;
        return this;
    }

    public QueryOptions scanConsistency(@Nullable ScanConsistency scanConsistency) {
        this.scanConsistency = scanConsistency;
        return this;
    }

    public QueryOptions readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiStatus.Experimental
    public QueryOptions raw(@Nullable Map<String, ?> raw) {
        this.raw = raw == null ? null : Collections.unmodifiableMap(new HashMap(raw));
        return this;
    }

    Unmodifiable build() {
        return new Unmodifiable(this);
    }

    static class Unmodifiable {
        private final @Nullable Duration timeout;
        private final @Nullable String clientContextId;
        private final @Nullable Map<String, ?> namedParameters;
        private final @Nullable List<?> positionalParameters;
        private final @Nullable QueryPriority priority;
        private final @Nullable ScanConsistency scanConsistency;
        private final @Nullable Duration scanWait;
        private final @Nullable Deserializer deserializer;
        private final @Nullable Boolean readOnly;
        private final @Nullable Map<String, ?> raw;

        Unmodifiable(QueryOptions builder) {
            this.timeout = builder.timeout;
            this.clientContextId = builder.clientContextId;
            this.namedParameters = builder.namedParameters;
            this.positionalParameters = builder.positionalParameters;
            this.priority = builder.priority;
            this.scanConsistency = builder.scanConsistency;
            this.scanWait = builder.scanWait;
            this.deserializer = builder.deserializer;
            this.readOnly = builder.readOnly;
            this.raw = builder.raw;
        }

        void injectParams(ObjectNode query) {
            boolean namedParametersPresent;
            boolean positionalPresent;
            query.put("client_context_id", this.clientContextId != null ? this.clientContextId : UUID.randomUUID().toString());
            if (this.scanConsistency != null) {
                query.put("scan_consistency", this.scanConsistency.toString());
            }
            if (this.scanWait != null && this.scanConsistency != null && this.scanConsistency != ScanConsistency.NOT_BOUNDED) {
                query.put("scan_wait", Golang.encodeDurationToMs((Duration)this.scanWait));
            }
            boolean bl = positionalPresent = this.positionalParameters != null && !this.positionalParameters.isEmpty();
            if (positionalPresent) {
                try {
                    JsonNode jsonArray = (JsonNode)JacksonTransformers.MAPPER.convertValue((Object)JsonArray.from(this.positionalParameters), JsonNode.class);
                    query.set("args", jsonArray);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unsupported parameter type.", e);
                }
            }
            boolean bl2 = namedParametersPresent = this.namedParameters != null && !this.namedParameters.isEmpty();
            if (namedParametersPresent) {
                try {
                    JsonObject.from(this.namedParameters);
                    this.namedParameters.forEach((key, value) -> {
                        JsonNode jsonValue = Unmodifiable.toRepackagedJacksonNode(InternalJacksonSerDes.INSTANCE, value);
                        if (key.charAt(0) != '$') {
                            query.set("$" + key, jsonValue);
                        } else {
                            query.set(key, jsonValue);
                        }
                    });
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unsupported parameter type.", e);
                }
            }
            if (this.readOnly != null) {
                query.put("readonly", this.readOnly);
            }
            if (this.raw != null) {
                JsonObject.from(this.raw);
                this.raw.forEach((key, value) -> {
                    JsonNode jsonValue = Unmodifiable.toRepackagedJacksonNode(InternalJacksonSerDes.INSTANCE, value);
                    query.set(key, jsonValue);
                });
            }
        }

        public String toString() {
            return "QueryOptions{timeout=" + this.timeout + ", clientContextId='" + this.clientContextId + "', namedParameters=" + this.namedParameters + ", positionalParameters=" + this.positionalParameters + ", priority=" + this.priority + ", scanConsistency=" + this.scanConsistency + ", scanWait=" + this.scanWait + ", deserializer=" + this.deserializer + ", readOnly=" + this.readOnly + ", raw=" + this.raw + "}";
        }

        private static JsonNode toRepackagedJacksonNode(JsonSerializer serializer, Object value) {
            byte[] jsonArrayBytes = serializer.serialize(value);
            return Mapper.decodeIntoTree((byte[])jsonArrayBytes);
        }

        public @Nullable QueryPriority priority() {
            return this.priority;
        }

        public boolean readOnly() {
            return this.readOnly != null && this.readOnly != false;
        }

        public Map<String, Object> clientContext() {
            return Collections.emptyMap();
        }

        public @Nullable Duration timeout() {
            return this.timeout;
        }

        public @Nullable String clientContextId() {
            return this.clientContextId;
        }

        public @Nullable Map<String, ?> namedParameters() {
            return this.namedParameters;
        }

        public @Nullable List<?> positionalParameters() {
            return this.positionalParameters;
        }

        public @Nullable ScanConsistency scanConsistency() {
            return this.scanConsistency;
        }

        public @Nullable Duration scanWait() {
            return this.scanWait;
        }

        public @Nullable Deserializer deserializer() {
            return this.deserializer;
        }
    }
}

