/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.VersionAndGitHash;
import com.couchbase.client.core.util.Validators;
import com.couchbase.columnar.client.java.Cluster;
import com.couchbase.columnar.client.java.codec.Deserializer;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

class Environment
extends CoreEnvironment {
    private static final VersionAndGitHash version = VersionAndGitHash.from(Cluster.class);
    private final Deserializer deserializer;

    private Environment(Builder builder) {
        super((CoreEnvironment.Builder)builder);
        this.deserializer = Objects.requireNonNull(builder.deserializer);
    }

    protected String defaultAgentTitle() {
        return "columnar-java";
    }

    protected VersionAndGitHash clientVersionAndGitHash() {
        return version;
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    static class Builder
    extends CoreEnvironment.Builder<Builder> {
        private @Nullable Deserializer deserializer;

        Builder() {
        }

        public Builder deserializer(Deserializer deserializer) {
            this.deserializer = (Deserializer)Validators.notNull((Object)deserializer, (String)"deserializer");
            return this;
        }

        public Environment build() {
            return new Environment(this);
        }
    }
}

