/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.json;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.columnar.client.java.internal.JacksonTransformers;
import com.couchbase.columnar.client.java.json.JsonArray;
import com.couchbase.columnar.client.java.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.util.annotation.Nullable;

public final class JsonObject
extends JsonValue {
    private final Map<String, Object> content;

    private JsonObject() {
        this.content = new HashMap<String, Object>();
    }

    private JsonObject(int initialCapacity) {
        this.content = new HashMap<String, Object>(initialCapacity);
    }

    public static JsonObject create() {
        return new JsonObject();
    }

    public static JsonObject create(int initialCapacity) {
        return new JsonObject(initialCapacity);
    }

    public static JsonObject from(Map<String, ?> mapData) {
        Objects.requireNonNull(mapData, "Null input Map unsupported");
        JsonObject result = new JsonObject(mapData.size());
        try {
            mapData.forEach((key, value) -> {
                Objects.requireNonNull(key, "The key is not allowed to be null");
                result.put((String)key, JsonObject.coerce(value));
            });
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Map key must be String", e);
        }
        return result;
    }

    public static JsonObject fromJson(String jsonObject) {
        try {
            return (JsonObject)JacksonTransformers.MAPPER.readValue(jsonObject, JsonObject.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert string to JsonObject", e);
        }
    }

    public static JsonObject fromJson(byte[] jsonObject) {
        try {
            return (JsonObject)JacksonTransformers.MAPPER.readValue(jsonObject, JsonObject.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert byte array to JsonObject", e);
        }
    }

    public JsonObject put(String name, @Nullable Object value) {
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, JsonObject.coerce(value));
        return this;
    }

    @Nullable
    public Object get(String name) {
        return this.content.get(name);
    }

    public JsonObject put(String name, @Nullable String value) {
        this.content.put(name, value);
        return this;
    }

    @Nullable
    public String getString(String name) {
        return (String)this.content.get(name);
    }

    public JsonObject put(String name, int value) {
        this.content.put(name, value);
        return this;
    }

    @Nullable
    public Integer getInt(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Integer) {
            return (Integer)number;
        }
        return number.intValue();
    }

    public JsonObject put(String name, long value) {
        this.content.put(name, value);
        return this;
    }

    @Nullable
    public Long getLong(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Long) {
            return (Long)number;
        }
        return number.longValue();
    }

    public JsonObject put(String name, double value) {
        this.content.put(name, value);
        return this;
    }

    @Nullable
    public Double getDouble(String name) {
        Number number = (Number)this.content.get(name);
        if (number == null) {
            return null;
        }
        if (number instanceof Double) {
            return (Double)number;
        }
        return number.doubleValue();
    }

    public JsonObject put(String name, boolean value) {
        this.content.put(name, value);
        return this;
    }

    @Nullable
    public Boolean getBoolean(String name) {
        return (Boolean)this.content.get(name);
    }

    public JsonObject put(String name, @Nullable JsonObject value) {
        if (this == value) {
            throw new IllegalArgumentException("Cannot put self");
        }
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, @Nullable Map<String, ?> value) {
        return this.put(name, value == null ? null : JsonObject.from(value));
    }

    @Nullable
    public JsonObject getObject(String name) {
        return (JsonObject)this.content.get(name);
    }

    public JsonObject put(String name, @Nullable JsonArray value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, @Nullable Number value) {
        this.content.put(name, value);
        return this;
    }

    public JsonObject put(String name, @Nullable List<?> value) {
        return this.put(name, value == null ? null : JsonArray.from(value));
    }

    @Nullable
    public JsonArray getArray(String name) {
        return (JsonArray)this.content.get(name);
    }

    @Nullable
    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.content.get(name);
    }

    @Nullable
    public BigDecimal getBigDecimal(String name) {
        Object found = this.content.get(name);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return BigDecimal.valueOf((Double)found);
        }
        return (BigDecimal)found;
    }

    @Nullable
    public Number getNumber(String name) {
        return (Number)this.content.get(name);
    }

    public JsonObject putNull(String name) {
        this.content.put(name, null);
        return this;
    }

    public JsonObject removeKey(String name) {
        this.content.remove(name);
        return this;
    }

    public Set<String> getNames() {
        return this.content.keySet();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> copy = new HashMap<String, Object>(this.content.size());
        for (Map.Entry<String, Object> entry : this.content.entrySet()) {
            Object content = entry.getValue();
            if (content instanceof JsonObject) {
                copy.put(entry.getKey(), ((JsonObject)content).toMap());
                continue;
            }
            if (content instanceof JsonArray) {
                copy.put(entry.getKey(), ((JsonArray)content).toList());
                continue;
            }
            copy.put(entry.getKey(), content);
        }
        return copy;
    }

    public boolean containsKey(String name) {
        return this.content.containsKey(name);
    }

    public boolean containsValue(Object value) {
        return this.content.containsValue(value);
    }

    public int size() {
        return this.content.size();
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot convert JsonObject to Json String", e);
        }
    }

    public byte[] toBytes() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot convert JsonObject to Json byte array", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonObject that = (JsonObject)o;
        return Objects.equals(this.content, that.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }
}

