/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.internal;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonGenerator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonParser;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonToken;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.Version;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationContext;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonDeserializer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonSerializer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.SerializerProvider;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.module.SimpleModule;
import com.couchbase.columnar.client.java.json.JsonArray;
import com.couchbase.columnar.client.java.json.JsonObject;
import java.io.IOException;
import org.jetbrains.annotations.ApiStatus;
import reactor.util.annotation.Nullable;

@ApiStatus.Internal
public class RepackagedJsonValueModule
extends SimpleModule {
    public RepackagedJsonValueModule() {
        super(new Version(1, 0, 0, null, "com.couchbase", "JsonValueModule"));
        this.addSerializer(JsonObject.class, new JsonObjectSerializer());
        this.addDeserializer(JsonObject.class, new JsonObjectDeserializer());
        this.addSerializer(JsonArray.class, new JsonArraySerializer());
        this.addDeserializer(JsonArray.class, new JsonArrayDeserializer());
    }

    private static void expectCurrentToken(JsonParser parser, JsonToken expected) throws IOException {
        if (RepackagedJsonValueModule.currentToken(parser) != expected) {
            throw new IOException("Expected " + String.valueOf(expected) + " but got " + String.valueOf(RepackagedJsonValueModule.currentToken(parser)));
        }
    }

    private static JsonToken currentToken(JsonParser parser) {
        return parser.getCurrentToken();
    }

    static class JsonObjectSerializer
    extends JsonSerializer<JsonObject> {
        JsonObjectSerializer() {
        }

        public void serialize(JsonObject value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeObject(value.toMap());
        }
    }

    static class JsonObjectDeserializer
    extends AbstractJsonValueDeserializer<JsonObject> {
        JsonObjectDeserializer() {
        }

        public JsonObject deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            return this.decodeObject(jp);
        }
    }

    static class JsonArraySerializer
    extends JsonSerializer<JsonArray> {
        JsonArraySerializer() {
        }

        public void serialize(JsonArray value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeObject(value.toList());
        }
    }

    static class JsonArrayDeserializer
    extends AbstractJsonValueDeserializer<JsonArray> {
        JsonArrayDeserializer() {
        }

        public JsonArray deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            return this.decodeArray(jp);
        }
    }

    static abstract class AbstractJsonValueDeserializer<T>
    extends JsonDeserializer<T> {
        AbstractJsonValueDeserializer() {
        }

        JsonObject decodeObject(JsonParser parser) throws IOException {
            RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.START_OBJECT);
            JsonObject result = JsonObject.create();
            JsonToken current;
            while ((current = parser.nextToken()) != JsonToken.END_OBJECT) {
                RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.FIELD_NAME);
                parser.nextToken();
                result.put(parser.currentName(), this.decodeValue(parser));
            }
            return result;
        }

        JsonArray decodeArray(JsonParser parser) throws IOException {
            RepackagedJsonValueModule.expectCurrentToken(parser, JsonToken.START_ARRAY);
            JsonArray result = JsonArray.create();
            JsonToken current;
            while ((current = parser.nextToken()) != JsonToken.END_ARRAY) {
                result.add(this.decodeValue(parser));
            }
            return result;
        }

        @Nullable
        Object decodeValue(JsonParser parser) throws IOException {
            JsonToken current = RepackagedJsonValueModule.currentToken(parser);
            switch (current) {
                case START_OBJECT: {
                    return this.decodeObject(parser);
                }
                case START_ARRAY: {
                    return this.decodeArray(parser);
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return parser.getBooleanValue();
                }
                case VALUE_STRING: {
                    return parser.getValueAsString();
                }
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: {
                    return parser.getNumberValue();
                }
                case VALUE_NULL: {
                    return null;
                }
            }
            throw new IOException("Unexpected JSON token: " + String.valueOf(current));
        }
    }
}

