/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.json;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.columnar.client.java.internal.JacksonTransformers;
import com.couchbase.columnar.client.java.json.JsonObject;
import com.couchbase.columnar.client.java.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public final class JsonArray
extends JsonValue
implements Iterable<Object> {
    private final List<Object> content;

    private JsonArray() {
        this.content = new ArrayList<Object>();
    }

    private JsonArray(int initialCapacity) {
        this.content = new ArrayList<Object>(initialCapacity);
    }

    public static JsonArray create() {
        return new JsonArray();
    }

    public static JsonArray create(int initialCapacity) {
        return new JsonArray(initialCapacity);
    }

    public static JsonArray from(Object ... items) {
        JsonArray array = new JsonArray(items.length);
        for (Object item : items) {
            array.add(JsonValue.coerce(item));
        }
        return array;
    }

    public static JsonArray from(List<?> items) {
        JsonArray array = new JsonArray(items.size());
        for (Object item : items) {
            array.add(JsonValue.coerce(item));
        }
        return array;
    }

    @Stability.Internal
    static JsonArray fromIterable(Iterable<?> items) {
        JsonArray array = new JsonArray();
        for (Object it : items) {
            array.add(JsonValue.coerce(it));
        }
        return array;
    }

    public static JsonArray fromJson(String jsonArray) {
        try {
            return (JsonArray)JacksonTransformers.MAPPER.readValue(jsonArray, JsonArray.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert string to JsonArray", e);
        }
    }

    public static JsonArray fromJson(byte[] jsonArray) {
        try {
            return (JsonArray)JacksonTransformers.MAPPER.readValue(jsonArray, JsonArray.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert byte array to JsonArray", e);
        }
    }

    @Nullable
    public Object get(int index) {
        return this.content.get(index);
    }

    public JsonArray add(@Nullable Object value) {
        if (value == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        this.content.add(JsonArray.coerce(value));
        return this;
    }

    public JsonArray addNull() {
        this.content.add(null);
        return this;
    }

    public JsonArray add(@Nullable String value) {
        this.content.add(value);
        return this;
    }

    @Nullable
    public String getString(int index) {
        return (String)this.content.get(index);
    }

    public JsonArray add(long value) {
        this.content.add(value);
        return this;
    }

    @Nullable
    public Long getLong(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    public JsonArray add(int value) {
        this.content.add(value);
        return this;
    }

    @Nullable
    public Integer getInt(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public JsonArray add(double value) {
        this.content.add(value);
        return this;
    }

    @Nullable
    public Double getDouble(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        return n.doubleValue();
    }

    public JsonArray add(boolean value) {
        this.content.add(value);
        return this;
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.content.get(index);
    }

    public JsonArray add(@Nullable JsonObject value) {
        this.content.add(value);
        return this;
    }

    public JsonArray add(Map<String, ?> value) {
        return this.add(JsonObject.from(value));
    }

    public JsonObject getObject(int index) {
        return (JsonObject)this.content.get(index);
    }

    public JsonArray add(@Nullable JsonArray value) {
        if (value == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        this.content.add(value);
        return this;
    }

    public JsonArray add(@Nullable List<?> value) {
        return value == null ? this.addNull() : this.add(JsonArray.from(value));
    }

    public JsonArray add(@Nullable Number value) {
        this.content.add(value);
        return this;
    }

    @Nullable
    public JsonArray getArray(int index) {
        return (JsonArray)this.content.get(index);
    }

    @Nullable
    public BigInteger getBigInteger(int index) {
        return (BigInteger)this.content.get(index);
    }

    @Nullable
    public BigDecimal getBigDecimal(int index) {
        Object found = this.content.get(index);
        if (found == null) {
            return null;
        }
        if (found instanceof Double) {
            return BigDecimal.valueOf((Double)found);
        }
        return (BigDecimal)found;
    }

    @Nullable
    public Number getNumber(int index) {
        return (Number)this.content.get(index);
    }

    public List<Object> toList() {
        ArrayList<Object> copy = new ArrayList<Object>(this.content.size());
        for (Object o : this.content) {
            if (o instanceof JsonObject) {
                copy.add(((JsonObject)o).toMap());
                continue;
            }
            if (o instanceof JsonArray) {
                copy.add(((JsonArray)o).toList());
                continue;
            }
            copy.add(o);
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public boolean contains(@Nullable Object value) {
        return this.content.contains(value);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.content.iterator();
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert JsonArray to Json String", e);
        }
    }

    public byte[] toBytes() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsBytes((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot convert JsonArray to Json byte array", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray objects = (JsonArray)o;
        return Objects.equals(this.content, objects.content);
    }

    public int hashCode() {
        return Objects.hash(this.content);
    }
}

