/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java.internal;

import com.couchbase.client.core.deps.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import com.couchbase.columnar.client.java.internal.Certificates;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import org.jetbrains.annotations.ApiStatus;
import reactor.util.annotation.Nullable;

@ApiStatus.Internal
public class TrustSource {
    @Nullable
    private final List<X509Certificate> certificates;
    @Nullable
    private final TrustManagerFactory factory;

    private TrustSource(@Nullable List<X509Certificate> certificates, @Nullable TrustManagerFactory factory) {
        if (TrustSource.countNonNull(certificates, factory) != 1) {
            throw new IllegalArgumentException("Must specify exactly one of 'certificates' or `factory'");
        }
        if (certificates != null && certificates.isEmpty()) {
            throw new IllegalArgumentException("When specifying a list of certificates, the list must not be empty.");
        }
        this.certificates = certificates;
        this.factory = factory;
    }

    public static TrustSource fromJvm() {
        return TrustSource.from(Certificates.getJvmCertificates());
    }

    public static TrustSource from(Path pemFilePath) {
        List<X509Certificate> certs = Certificates.read(pemFilePath);
        if (certs.isEmpty()) {
            throw new IllegalArgumentException("PEM file contained no suitable certificates: " + pemFilePath);
        }
        return TrustSource.from(certs);
    }

    public static TrustSource from(List<X509Certificate> certificates) {
        Objects.requireNonNull(certificates);
        if (certificates.isEmpty()) {
            throw new IllegalArgumentException("certificates list must not be empty");
        }
        return new TrustSource(certificates, null);
    }

    public static TrustSource from(TrustManagerFactory factory) {
        return new TrustSource(null, Objects.requireNonNull(factory));
    }

    public static TrustSource insecure() {
        return TrustSource.from(InsecureTrustManagerFactory.INSTANCE);
    }

    @Nullable
    public List<X509Certificate> certificates() {
        return this.certificates;
    }

    @Nullable
    public TrustManagerFactory trustManagerFactory() {
        return this.factory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TrustSource{");
        if (this.certificates != null) {
            sb.append("certificates=").append(TrustSource.describe(this.certificates));
        } else {
            sb.append("factory=").append(this.factory);
        }
        sb.append("}");
        return sb.toString();
    }

    private static int countNonNull(Object ... objects) {
        return (int)Arrays.stream(objects).filter(Objects::nonNull).count();
    }

    @Nullable
    private static String describe(@Nullable List<X509Certificate> certs) {
        if (certs == null) {
            return null;
        }
        if (certs.size() <= 10) {
            return certs.stream().map(TrustSource::describe).collect(Collectors.joining(", ", "[", "]"));
        }
        return "(" + certs.size() + " certificates)";
    }

    private static String describe(X509Certificate cert) {
        return cert.getSubjectX500Principal() + " (valid from " + cert.getNotBefore().toInstant() + " to " + cert.getNotAfter().toInstant() + ")";
    }
}

