/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.columnar.client.java;

import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.columnar.client.java.Cluster;
import com.couchbase.columnar.client.java.Database;
import com.couchbase.columnar.client.java.QueryMetadata;
import com.couchbase.columnar.client.java.QueryOptions;
import com.couchbase.columnar.client.java.QueryResult;
import com.couchbase.columnar.client.java.Queryable;
import com.couchbase.columnar.client.java.Row;
import java.util.Objects;
import java.util.function.Consumer;

public final class Scope
implements Queryable {
    private final Cluster cluster;
    private final Database database;
    private final String name;

    Scope(Cluster cluster, Database database, String name) {
        this.cluster = Objects.requireNonNull(cluster);
        this.database = Objects.requireNonNull(database);
        this.name = Objects.requireNonNull(name);
    }

    public Database database() {
        return this.database;
    }

    public String name() {
        return this.name;
    }

    @Override
    public QueryResult executeQuery(String statement, Consumer<QueryOptions> options) {
        return this.cluster.queryExecutor.queryBuffered(statement, options, new CoreBucketAndScope(this.database.name(), this.name));
    }

    @Override
    public QueryMetadata executeStreamingQuery(String statement, Consumer<Row> rowAction, Consumer<QueryOptions> options) {
        return this.cluster.queryExecutor.queryStreaming(statement, options, new CoreBucketAndScope(this.database.name(), this.name), rowAction);
    }

    public String toString() {
        return "Scope{name='" + this.name + "', databaseName='" + this.database.name() + "'}";
    }
}

