/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.ComplexKey;
import com.couchbase.client.protocol.views.OnError;
import com.couchbase.client.protocol.views.Stale;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Query {
    private static final int PARAM_REDUCE_OFFSET = 0;
    private static final int PARAM_LIMIT_OFFSET = 2;
    private static final int PARAM_SKIP_OFFSET = 4;
    private static final int PARAM_STALE_OFFSET = 6;
    private static final int PARAM_GROUPLEVEL_OFFSET = 8;
    private static final int PARAM_GROUP_OFFSET = 10;
    private static final int PARAM_ONERROR_OFFSET = 12;
    private static final int PARAM_DEBUG_OFFSET = 14;
    private static final int PARAM_DESCENDING_OFFSET = 16;
    private static final int PARAM_INCLUSIVEEND_OFFSET = 18;
    private static final int PARAM_STARTKEY_OFFSET = 20;
    private static final int PARAM_STARTKEYDOCID_OFFSET = 22;
    private static final int PARAM_ENDKEY_OFFSET = 24;
    private static final int PARAM_ENDKEYDOCID_OFFSET = 26;
    private static final int PARAM_KEYS_OFFSET = 28;
    private static final int PARAM_KEY_OFFSET = 30;
    private static final int PARAM_BBOX_OFFSET = 32;
    private static final int NUM_PARAMS = 17;
    private final String[] params;
    private boolean includeDocs;
    private static final Pattern quotePattern = Pattern.compile("^(\".*|\\{.*|\\[.*|true|false|null|-?[\\d,]*([.Ee]\\d+)?)$");
    private final NumberFormat numberFormat = NumberFormat.getInstance();

    public Query() {
        this(new String[34]);
    }

    Query(String[] params) {
        this.params = params;
    }

    public Query setReduce(boolean reduce) {
        this.params[0] = "reduce";
        this.params[1] = Boolean.toString(reduce);
        return this;
    }

    public Query setLimit(int limit) {
        this.params[2] = "limit";
        this.params[3] = Integer.toString(limit);
        return this;
    }

    public Query setGroup(boolean group) {
        this.params[10] = "group";
        this.params[11] = Boolean.toString(group);
        return this;
    }

    public Query setGroupLevel(int grouplevel) {
        this.params[8] = "group_level";
        this.params[9] = Integer.toString(grouplevel);
        return this;
    }

    public Query setIncludeDocs(boolean include) {
        this.includeDocs = include;
        return this;
    }

    public Query setInclusiveEnd(boolean inclusiveend) {
        this.params[18] = "inclusive_end";
        this.params[19] = Boolean.toString(inclusiveend);
        return this;
    }

    public Query setSkip(int skip) {
        this.params[4] = "skip";
        this.params[5] = Integer.toString(skip);
        return this;
    }

    public Query setStale(Stale stale) {
        this.params[6] = "stale";
        this.params[7] = stale.toString();
        return this;
    }

    public Query setOnError(OnError onError) {
        this.params[12] = "on_error";
        this.params[13] = onError.toString();
        return this;
    }

    public Query setDebug(boolean debug) {
        this.params[14] = "debug";
        this.params[15] = Boolean.toString(debug);
        return this;
    }

    public Query setDescending(boolean descending) {
        this.params[16] = "descending";
        this.params[17] = Boolean.toString(descending);
        return this;
    }

    public Query setKey(ComplexKey key) {
        this.params[30] = "key";
        this.params[31] = this.encode(key.toJson());
        return this;
    }

    public Query setKey(String key) {
        this.params[30] = "key";
        this.params[31] = this.encode(this.quote(key));
        return this;
    }

    public Query setKeys(ComplexKey keys) {
        this.params[28] = "keys";
        this.params[29] = this.encode(keys.toJson());
        return this;
    }

    public Query setKeys(String keys) {
        this.params[28] = "keys";
        this.params[29] = this.encode(this.quote(keys));
        return this;
    }

    public Query setStartkeyDocID(String startkeydocid) {
        this.params[22] = "startkey_docid";
        this.params[23] = this.encode(startkeydocid);
        return this;
    }

    public Query setEndkeyDocID(String endkeydocid) {
        this.params[26] = "endkey_docid";
        this.params[27] = this.encode(endkeydocid);
        return this;
    }

    public Query setRange(String startkey, String endkey) {
        this.setRangeStart(startkey);
        this.setRangeEnd(endkey);
        return this;
    }

    public Query setRange(ComplexKey startkey, ComplexKey endkey) {
        this.setRangeStart(startkey);
        this.setRangeEnd(endkey);
        return this;
    }

    public Query setRangeStart(String startkey) {
        this.params[20] = "startkey";
        this.params[21] = this.encode(this.quote(startkey));
        return this;
    }

    public Query setRangeStart(ComplexKey startkey) {
        this.params[20] = "startkey";
        this.params[21] = this.encode(startkey.toJson());
        return this;
    }

    public Query setRangeEnd(String endkey) {
        this.params[24] = "endkey";
        this.params[25] = this.encode(this.quote(endkey));
        return this;
    }

    public Query setRangeEnd(ComplexKey endkey) {
        this.params[24] = "endkey";
        this.params[25] = this.encode(endkey.toJson());
        return this;
    }

    public Query setBbox(double lowerLeftLong, double lowerLeftLat, double upperRightLong, double upperRightLat) {
        String combined = lowerLeftLong + "," + lowerLeftLat + ',' + upperRightLong + ',' + upperRightLat;
        this.params[32] = "bbox";
        this.params[33] = this.encode(combined);
        return this;
    }

    public boolean willReduce() {
        String reduce = this.params[1];
        if (reduce == null) {
            return false;
        }
        return Boolean.valueOf(reduce);
    }

    public boolean willIncludeDocs() {
        return this.includeDocs;
    }

    public int getLimit() {
        String limit = this.params[3];
        if (limit == null) {
            return -1;
        }
        return Integer.valueOf(limit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        for (int i = 0; i < this.params.length; ++i) {
            boolean even;
            if (this.params[i] == null) {
                ++i;
                continue;
            }
            boolean bl = even = i % 2 == 0;
            if (even) {
                sb.append(firstParam ? "?" : "&");
            }
            sb.append(this.params[i]);
            firstParam = false;
            if (!even) continue;
            sb.append('=');
        }
        return sb.toString();
    }

    public Map<String, Object> getArgs() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        for (int i = 0; i < this.params.length; ++i) {
            boolean even;
            boolean bl = even = i % 2 == 0;
            if (!even || this.params[i] == null) continue;
            args.put(this.params[i], this.params[i + 1]);
        }
        return args;
    }

    protected String encode(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not prepare view argument: " + ex);
        }
    }

    protected String quote(String source) {
        if (quotePattern.matcher(source).matches()) {
            ParsePosition parsePosition = new ParsePosition(0);
            Number result = this.numberFormat.parse(source, parsePosition);
            if (parsePosition.getIndex() == source.length()) {
                return result.toString();
            }
            return source;
        }
        return '\"' + source + '\"';
    }

    public Query copy() {
        Query copied = new Query((String[])this.params.clone());
        copied.setIncludeDocs(this.willIncludeDocs());
        return copied;
    }
}

