/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.TapConnectionProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.naming.ConfigurationException;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.TapOperation;
import net.spy.memcached.tapmessage.RequestMessage;
import net.spy.memcached.tapmessage.ResponseMessage;
import net.spy.memcached.tapmessage.TapAck;
import net.spy.memcached.tapmessage.TapOpcode;
import net.spy.memcached.tapmessage.TapStream;

public class TapClient
extends net.spy.memcached.TapClient {
    private List<URI> baseList;
    private String bucketName;
    private String pwd;

    public TapClient(List<URI> baseList, String bucketName, String pwd) {
        super(new InetSocketAddress[0]);
        for (URI bu : baseList) {
            if (bu.isAbsolute()) continue;
            throw new IllegalArgumentException("The base URI must be absolute");
        }
        this.baseList = baseList;
        this.bucketName = bucketName;
        this.pwd = pwd;
    }

    public ResponseMessage getNextMessage() {
        return this.getNextMessage(1L, TimeUnit.SECONDS);
    }

    public ResponseMessage getNextMessage(long time, TimeUnit timeunit) {
        try {
            Object m = this.rqueue.poll(time, timeunit);
            if (m == null) {
                return null;
            }
            if (m instanceof ResponseMessage) {
                return (ResponseMessage)m;
            }
            if (m instanceof TapAck) {
                TapAck ack = (TapAck)m;
                this.tapAck((TapConnectionProvider)ack.getConn(), ack.getNode(), ack.getOpcode(), ack.getOpaque(), ack.getCallback());
                return null;
            }
            throw new RuntimeException("Unexpected tap message type");
        }
        catch (InterruptedException e) {
            this.shutdown();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreMessages() {
        if (!this.rqueue.isEmpty()) {
            return true;
        }
        HashMap hashMap = this.omap;
        synchronized (hashMap) {
            for (TapStream op : this.omap.keySet()) {
                if (!op.isCompleted() && !op.isCancelled() && !op.hasErrored()) continue;
                ((net.spy.memcached.TapConnectionProvider)this.omap.get(op)).shutdown();
                this.omap.remove(op);
            }
            if (this.omap.size() > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TapStream tapCustom(final String id, final RequestMessage message) throws ConfigurationException, IOException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.baseList, this.bucketName, this.pwd);
        final TapStream ts = new TapStream();
        conn.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                TapOperation op = conn.getOpFactory().tapCustom(id, message, (OperationCallback)new TapOperation.Callback(){

                    public void receivedStatus(OperationStatus status) {
                    }

                    public void gotData(ResponseMessage tapMessage) {
                        TapClient.this.rqueue.add(tapMessage);
                        TapClient.this.messagesRead++;
                    }

                    public void gotAck(MemcachedNode node, TapOpcode opcode, int opaque) {
                        TapClient.this.rqueue.add(new TapAck((net.spy.memcached.TapConnectionProvider)conn, node, opcode, opaque, (OperationCallback)this));
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
                ts.addOp(op);
                return op;
            }
        });
        HashMap hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(ts, conn);
        }
        return ts;
    }

    public TapStream tapBackfill(String id, int runTime, TimeUnit timeunit) throws IOException, ConfigurationException {
        return this.tapBackfill(id, -1L, runTime, timeunit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TapStream tapBackfill(final String id, final long date, final int runTime, final TimeUnit timeunit) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.baseList, this.bucketName, this.pwd);
        final TapStream ts = new TapStream();
        conn.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(final MemcachedNode n, final CountDownLatch latch) {
                TapOperation op = conn.getOpFactory().tapBackfill(id, date, (OperationCallback)new TapOperation.Callback(){

                    public void receivedStatus(OperationStatus status) {
                    }

                    public void gotData(ResponseMessage tapMessage) {
                        if (!conn.isPrimaryForKey(n, tapMessage.getKey())) {
                            return;
                        }
                        TapClient.this.rqueue.add(tapMessage);
                        TapClient.this.messagesRead++;
                    }

                    public void gotAck(MemcachedNode node, TapOpcode opcode, int opaque) {
                        TapClient.this.rqueue.add(new TapAck((net.spy.memcached.TapConnectionProvider)conn, node, opcode, opaque, (OperationCallback)this));
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
                ts.addOp(op);
                return op;
            }
        });
        HashMap hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(ts, conn);
        }
        if (runTime > 0) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(TimeUnit.MILLISECONDS.convert(runTime, timeunit));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    conn.shutdown();
                    HashMap hashMap = TapClient.this.omap;
                    synchronized (hashMap) {
                        TapClient.this.omap.remove(ts);
                    }
                }
            };
            new Thread(r).start();
        }
        return ts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TapStream tapDump(final String id) throws IOException, ConfigurationException {
        final TapConnectionProvider conn = new TapConnectionProvider(this.baseList, this.bucketName, this.pwd);
        final TapStream ts = new TapStream();
        conn.broadcastOp(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                TapOperation op = conn.getOpFactory().tapDump(id, (OperationCallback)new TapOperation.Callback(){

                    public void receivedStatus(OperationStatus status) {
                    }

                    public void gotData(ResponseMessage tapMessage) {
                        TapClient.this.rqueue.add(tapMessage);
                        TapClient.this.messagesRead++;
                    }

                    public void gotAck(MemcachedNode node, TapOpcode opcode, int opaque) {
                        TapClient.this.rqueue.add(new TapAck((net.spy.memcached.TapConnectionProvider)conn, node, opcode, opaque, (OperationCallback)this));
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
                ts.addOp(op);
                return op;
            }
        });
        HashMap hashMap = this.omap;
        synchronized (hashMap) {
            this.omap.put(ts, conn);
        }
        return ts;
    }

    private void tapAck(TapConnectionProvider conn, MemcachedNode node, TapOpcode opcode, int opaque, OperationCallback cb) {
        TapOperation op = conn.getOpFactory().tapAck(opcode, opaque, cb);
        conn.addTapAckOp(node, (Operation)op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap hashMap = this.omap;
        synchronized (hashMap) {
            for (Map.Entry me : this.omap.entrySet()) {
                ((net.spy.memcached.TapConnectionProvider)me.getValue()).shutdown();
            }
        }
    }

    public long getMessagesRead() {
        return this.messagesRead;
    }
}

