/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.cnc.events.io.UnknownServerPushRequestReceivedEvent;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import java.util.Objects;

public class ServerPushHandler
extends ChannelInboundHandlerAdapter {
    private final EndpointContext endpointContext;

    public ServerPushHandler(EndpointContext endpointContext) {
        this.endpointContext = Objects.requireNonNull(endpointContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf buf;
        if (msg instanceof ByteBuf && MemcacheProtocol.magic(buf = (ByteBuf)msg) == MemcacheProtocol.Magic.SERVER_PUSH_REQUEST.magic()) {
            try {
                byte opcodeByte = MemcacheProtocol.opcode(buf);
                MemcacheProtocol.ServerPushOpcode opcode = MemcacheProtocol.ServerPushOpcode.of(opcodeByte);
                if (opcode == MemcacheProtocol.ServerPushOpcode.CLUSTERMAP_CHANGE_NOTIFICATION) {
                    this.endpointContext.core().configurationProvider().signalConfigChanged();
                    return;
                }
                this.endpointContext.core().environment().eventBus().publish(new UnknownServerPushRequestReceivedEvent(null, ByteBufUtil.getBytes(buf)));
                return;
            }
            finally {
                buf.release();
            }
        }
        ctx.fireChannelRead(msg);
    }
}

