/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.MatchPhraseQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreMatchPhraseQuery
extends CoreSearchQuery {
    private final String matchPhrase;
    @Nullable
    private final String field;
    @Nullable
    private final String analyzer;

    public CoreMatchPhraseQuery(String matchPhrase, @Nullable String field, @Nullable String analyzer, @Nullable Double boost) {
        super(boost);
        this.matchPhrase = Validators.notNull(matchPhrase, "Match phrase");
        this.field = field;
        this.analyzer = analyzer;
    }

    @Override
    public void injectParams(ObjectNode input) {
        input.put("match_phrase", this.matchPhrase);
        if (this.field != null) {
            input.put("field", this.field);
        }
        if (this.analyzer != null) {
            input.put("analyzer", this.analyzer);
        }
    }

    @Override
    public Query asProtostellar() {
        MatchPhraseQuery.Builder builder = MatchPhraseQuery.newBuilder().setPhrase(this.matchPhrase);
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.analyzer != null) {
            builder.setAnalyzer(this.analyzer);
        }
        return Query.newBuilder().setMatchPhraseQuery(builder).build();
    }
}

