/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.Query;
import com.couchbase.client.protostellar.search.v1.TermQuery;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreTermQuery
extends CoreSearchQuery {
    private final String term;
    @Nullable
    private final String field;
    @Nullable
    private final Integer fuzziness;
    @Nullable
    private final Integer prefixLength;

    public CoreTermQuery(String term, @Nullable String field, @Nullable Integer fuzziness, @Nullable Integer prefixLength, @Nullable Double boost) {
        super(boost);
        this.term = Validators.notNull(term, "Term");
        this.field = field;
        this.fuzziness = fuzziness;
        this.prefixLength = prefixLength;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.put("term", this.term);
        if (this.field != null) {
            input.put("field", this.field);
        }
        if (this.fuzziness != null && this.fuzziness > 0) {
            input.put("fuzziness", this.fuzziness);
            if (this.prefixLength != null && this.prefixLength > 0) {
                input.put("prefix_length", this.prefixLength);
            }
        }
    }

    @Override
    public Query asProtostellar() {
        TermQuery.Builder builder = TermQuery.newBuilder().setTerm(this.term);
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.prefixLength != null) {
            builder.setPrefixLength(this.prefixLength.intValue());
        }
        if (this.fuzziness != null) {
            builder.setFuzziness(this.fuzziness.intValue());
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setTermQuery(builder).build();
    }
}

