/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreExpiry;
import com.couchbase.client.core.api.kv.CoreKvParamValidators;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocGetCommand;
import com.couchbase.client.core.api.kv.CoreSubdocMutateCommand;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.deps.com.google.protobuf.Timestamp;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarKeyValueRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.protostellar.kv.ProtostellarCoreEncodedContent;
import com.couchbase.client.protostellar.kv.v1.CompressionEnabled;
import com.couchbase.client.protostellar.kv.v1.ExistsRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndLockRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndTouchRequest;
import com.couchbase.client.protostellar.kv.v1.GetRequest;
import com.couchbase.client.protostellar.kv.v1.InsertRequest;
import com.couchbase.client.protostellar.kv.v1.LookupInRequest;
import com.couchbase.client.protostellar.kv.v1.MutateInRequest;
import com.couchbase.client.protostellar.kv.v1.RemoveRequest;
import com.couchbase.client.protostellar.kv.v1.ReplaceRequest;
import com.couchbase.client.protostellar.kv.v1.TouchRequest;
import com.couchbase.client.protostellar.kv.v1.UnlockRequest;
import com.couchbase.client.protostellar.kv.v1.UpsertRequest;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Stability.Internal
public class CoreProtostellarKeyValueRequests {
    static final Timestamp NO_EXPIRY = Timestamp.getDefaultInstance();

    private CoreProtostellarKeyValueRequests() {
    }

    public static ProtostellarRequest<GetRequest> getRequest(CoreProtostellar core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, List<String> projections, boolean withExpiry, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateGetParams(opts, key, projections, withExpiry);
        GetRequest.Builder request = GetRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        if (compressionConfig.enabled()) {
            request.setCompression(CompressionEnabled.COMPRESSION_ENABLED_OPTIONAL);
        }
        if (!projections.isEmpty()) {
            request.addAllProject(projections);
        }
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<GetRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "get", CoreProtostellarUtil.createSpan(core, "get", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<GetAndLockRequest> getAndLockRequest(CoreProtostellar core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, Duration lockTime, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateGetAndLockParams(opts, key, lockTime);
        GetAndLockRequest.Builder request = GetAndLockRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setLockTime((int)lockTime.toMillis());
        if (compressionConfig.enabled()) {
            request.setCompression(CompressionEnabled.COMPRESSION_ENABLED_OPTIONAL);
        }
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<GetAndLockRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "get_and_lock", CoreProtostellarUtil.createSpan(core, "get_and_lock", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<GetAndTouchRequest> getAndTouchRequest(CoreProtostellar core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, CoreExpiry expiry, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateGetAndTouchParams(opts, key, expiry);
        GetAndTouchRequest.Builder request = GetAndTouchRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        if (compressionConfig.enabled()) {
            request.setCompression(CompressionEnabled.COMPRESSION_ENABLED_OPTIONAL);
        }
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<GetAndTouchRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "get_and_touch", CoreProtostellarUtil.createSpan(core, "get_and_touch", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<InsertRequest> insertRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateInsertParams(opts, key, content, durability, expiry);
        RequestSpan span = CoreProtostellarUtil.createSpan(core, "insert", durability, opts.parentSpan().orElse(null));
        ProtostellarCoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, span, compressionConfig);
        InsertRequest.Builder request = InsertRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContentFlags(encoded.flags());
        if (encoded.compressed()) {
            request.setContentCompressed(encoded.bytes());
        } else {
            request.setContentUncompressed(encoded.bytes());
        }
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        return new ProtostellarKeyValueRequest<InsertRequest>(request.build(), core, keyspace, key, durability, "insert", span, timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), encoded.flags());
    }

    public static ProtostellarRequest<ReplaceRequest> replaceRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateReplaceParams(opts, key, content, cas, durability, expiry, preserveExpiry);
        RequestSpan span = CoreProtostellarUtil.createSpan(core, "replace", durability, opts.parentSpan().orElse(null));
        ProtostellarCoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, span, compressionConfig);
        ReplaceRequest.Builder request = ReplaceRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContentFlags(encoded.flags());
        if (encoded.compressed()) {
            request.setContentCompressed(encoded.bytes());
        } else {
            request.setContentUncompressed(encoded.bytes());
        }
        if (cas != 0L) {
            request.setCas(cas);
        }
        if (!preserveExpiry) {
            expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        return new ProtostellarKeyValueRequest<ReplaceRequest>(request.build(), core, keyspace, key, durability, "replace", span, timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), encoded.encodingTimeNanos());
    }

    public static ProtostellarRequest<UpsertRequest> upsertRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, CompressionConfig compressionConfig) {
        CoreKvParamValidators.validateUpsertParams(opts, key, content, durability, expiry, preserveExpiry);
        RequestSpan span = CoreProtostellarUtil.createSpan(core, "upsert", durability, opts.parentSpan().orElse(null));
        ProtostellarCoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, span, compressionConfig);
        UpsertRequest.Builder request = UpsertRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContentFlags(encoded.flags()).setPreserveExpiryOnExisting(preserveExpiry);
        if (encoded.compressed()) {
            request.setContentCompressed(encoded.bytes());
        } else {
            request.setContentUncompressed(encoded.bytes());
        }
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        return new ProtostellarKeyValueRequest<UpsertRequest>(request.build(), core, keyspace, key, durability, "upsert", span, timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), encoded.encodingTimeNanos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProtostellarCoreEncodedContent encodedContent(CoreProtostellar core, Supplier<CoreEncodedContent> content, RequestSpan span, CompressionConfig compressionConfig) {
        CoreEncodedContent encoded;
        RequestSpan encodeSpan = core.context().coreResources().requestTracer().requestSpan("request_encoding", span);
        long start = System.nanoTime();
        boolean compressed = false;
        ByteString out = null;
        try {
            ByteBuf maybeCompressed;
            encoded = content.get();
            if (compressionConfig.enabled() && encoded.encoded().length >= compressionConfig.minSize() && (maybeCompressed = MemcacheProtocol.tryCompression(encoded.encoded(), compressionConfig.minRatio())) != null) {
                out = ByteString.copyFrom(maybeCompressed.array());
                compressed = true;
            }
            if (out == null) {
                out = ByteString.copyFrom(encoded.encoded());
            }
        }
        finally {
            encodeSpan.end();
        }
        return new ProtostellarCoreEncodedContent(out, encoded.flags(), compressed, System.nanoTime() - start);
    }

    public static ProtostellarRequest<RemoveRequest> removeRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, long cas, CoreDurability durability) {
        CoreKvParamValidators.validateRemoveParams(opts, key, cas, durability);
        RemoveRequest.Builder request = RemoveRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        if (cas != 0L) {
            request.setCas(cas);
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        return new ProtostellarKeyValueRequest<RemoveRequest>(request.build(), core, keyspace, key, durability, "remove", CoreProtostellarUtil.createSpan(core, "remove", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<ExistsRequest> existsRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key) {
        CoreKvParamValidators.validateExistsParams(opts, key);
        ExistsRequest.Builder request = ExistsRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<ExistsRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "exists", CoreProtostellarUtil.createSpan(core, "exists", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<TouchRequest> touchRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, CoreExpiry expiry) {
        CoreKvParamValidators.validateTouchParams(opts, key, expiry);
        TouchRequest.Builder request = TouchRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<TouchRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "touch", CoreProtostellarUtil.createSpan(core, "touch", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<UnlockRequest> unlockRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, long cas) {
        CoreKvParamValidators.validateUnlockParams(opts, key, cas, keyspace.toCollectionIdentifier());
        UnlockRequest request = UnlockRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setCas(cas).setKey(key).build();
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<UnlockRequest>(request, core, keyspace, key, CoreDurability.NONE, "unlock", CoreProtostellarUtil.createSpan(core, "unlock", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<MutateInRequest> mutateInRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, List<CoreSubdocMutateCommand> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, CoreExpiry expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        CoreKvParamValidators.validateSubdocMutateParams(opts, key, storeSemantics, cas);
        MutateInRequest.Builder request = MutateInRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).addAllSpecs(commands.stream().map(command -> {
            MutateInRequest.Spec.Operation operation;
            String path = command.path();
            switch (command.type()) {
                case COUNTER: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_COUNTER;
                    break;
                }
                case REPLACE: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_REPLACE;
                    break;
                }
                case DICT_ADD: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_INSERT;
                    break;
                }
                case DICT_UPSERT: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_UPSERT;
                    break;
                }
                case ARRAY_PUSH_FIRST: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_ARRAY_PREPEND;
                    break;
                }
                case ARRAY_PUSH_LAST: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_ARRAY_APPEND;
                    break;
                }
                case ARRAY_ADD_UNIQUE: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_ARRAY_ADD_UNIQUE;
                    break;
                }
                case ARRAY_INSERT: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_ARRAY_INSERT;
                    break;
                }
                case DELETE: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_REMOVE;
                    break;
                }
                case SET_DOC: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_REPLACE;
                    path = "";
                    break;
                }
                case DELETE_DOC: {
                    operation = MutateInRequest.Spec.Operation.OPERATION_REMOVE;
                    path = "";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sub-Document mutateIn command " + (Object)((Object)command.type()) + " is not supported in Protostellar");
                }
            }
            MutateInRequest.Spec.Builder builder = MutateInRequest.Spec.newBuilder().setOperation(operation).setPath(path).setContent(ByteString.copyFrom(command.fragment()));
            if (command.xattr() || command.expandMacro() || command.createParent()) {
                MutateInRequest.Spec.Flags.Builder flagsBuilder = MutateInRequest.Spec.Flags.newBuilder();
                if (command.xattr()) {
                    flagsBuilder.setXattr(command.xattr());
                }
                if (command.createParent()) {
                    flagsBuilder.setCreatePath(command.createParent());
                }
                if (command.expandMacro()) {
                    throw new IllegalArgumentException("expandMacro is not supported in Protostellar");
                }
                builder.setFlags(flagsBuilder);
            }
            return builder.build();
        }).collect(Collectors.toList()));
        switch (storeSemantics) {
            case REPLACE: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.STORE_SEMANTIC_REPLACE);
                break;
            }
            case UPSERT: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.STORE_SEMANTIC_UPSERT);
                break;
            }
            case INSERT: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.STORE_SEMANTIC_INSERT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sub-Document store semantic " + (Object)((Object)storeSemantics) + " is not supported in Protostellar");
            }
        }
        if (cas != 0L) {
            request.setCas(cas);
        }
        if (accessDeleted) {
            request.setFlags(MutateInRequest.Flags.newBuilder().setAccessDeleted(accessDeleted));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        if (createAsDeleted) {
            throw new IllegalArgumentException("createAsDeleted is not supported in mutateIn in Protostellar");
        }
        if (!preserveExpiry) {
            expiry.when(absolute -> request.setExpiryTime(CoreProtostellarUtil.toExpiryTime(absolute)), relative -> request.setExpirySecs(CoreProtostellarUtil.toExpirySeconds(relative)), () -> request.setExpiryTime(NO_EXPIRY));
        }
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        return new ProtostellarKeyValueRequest<MutateInRequest>(request.build(), core, keyspace, key, durability, "mutate_in", CoreProtostellarUtil.createSpan(core, "mutate_in", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }

    public static ProtostellarRequest<LookupInRequest> lookupInRequest(CoreProtostellar core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, List<CoreSubdocGetCommand> commands, boolean accessDeleted) {
        CoreKvParamValidators.validateSubdocGetParams(opts, key, commands);
        LookupInRequest.Builder request = LookupInRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).addAllSpecs(commands.stream().map(command -> {
            LookupInRequest.Spec.Operation operation;
            String path = command.path();
            switch (command.type()) {
                case GET: {
                    operation = LookupInRequest.Spec.Operation.OPERATION_GET;
                    break;
                }
                case EXISTS: {
                    operation = LookupInRequest.Spec.Operation.OPERATION_EXISTS;
                    break;
                }
                case COUNT: {
                    operation = LookupInRequest.Spec.Operation.OPERATION_COUNT;
                    break;
                }
                case GET_DOC: {
                    operation = LookupInRequest.Spec.Operation.OPERATION_GET;
                    path = "";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sub-Document lookupIn command " + (Object)((Object)command.type()) + " is not supported in Protostellar");
                }
            }
            LookupInRequest.Spec.Builder builder = LookupInRequest.Spec.newBuilder().setOperation(operation).setPath(path);
            if (command.xattr()) {
                LookupInRequest.Spec.Flags.Builder flagsBuilder = LookupInRequest.Spec.Flags.newBuilder();
                if (command.xattr()) {
                    flagsBuilder.setXattr(command.xattr());
                }
                builder.setFlags(flagsBuilder);
            }
            return builder.build();
        }).collect(Collectors.toList()));
        if (accessDeleted) {
            request.setFlags(LookupInRequest.Flags.newBuilder().setAccessDeleted(accessDeleted));
        }
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        return new ProtostellarKeyValueRequest<LookupInRequest>(request.build(), core, keyspace, key, CoreDurability.NONE, "lookup_in", CoreProtostellarUtil.createSpan(core, "lookup_in", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext(), 0L);
    }
}

