/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config.loader;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.config.loader.BaseBucketLoader;
import com.couchbase.client.core.error.BucketNotFoundDuringLoadException;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.NoAccessDuringConfigLoadException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.manager.BucketConfigRequest;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.NodeIdentifier;
import reactor.core.publisher.Mono;

public class ClusterManagerBucketLoader
extends BaseBucketLoader {
    public ClusterManagerBucketLoader(Core core) {
        super(core, ServiceType.MANAGER);
    }

    @Override
    protected Mono<byte[]> discoverConfig(NodeIdentifier seed, String bucket) {
        CoreContext ctx = this.core().context();
        return Mono.defer(() -> {
            BucketConfigRequest request = new BucketConfigRequest(ctx.environment().timeoutConfig().connectTimeout(), ctx, BestEffortRetryStrategy.INSTANCE, bucket, ctx.authenticator(), seed);
            this.core().send(request);
            return Reactor.wrap(request, request.response(), true);
        }).map(response -> {
            if (response.status().success()) {
                return response.config();
            }
            switch (response.status()) {
                case NOT_FOUND: {
                    throw new BucketNotFoundDuringLoadException("Bucket [\"" + RedactableArgument.redactMeta(bucket) + "\"] not found during loading");
                }
                case NO_ACCESS: {
                    throw new NoAccessDuringConfigLoadException("Client was denied access to bucket [\"" + RedactableArgument.redactMeta(bucket) + "\"] during config loading. Common causes include invalid credentials or insufficient permissions.");
                }
            }
            throw new ConfigException("Received error status from ClusterManagerBucketLoader: " + response);
        });
    }
}

