/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.apptelemetry.collector;

import com.couchbase.client.core.cnc.apptelemetry.collector.AppTelemetryRequestType;
import com.couchbase.client.core.endpoint.http.CoreHttpRequest;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.kv.GetAndLockRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.ReplicaGetRequest;
import com.couchbase.client.core.msg.kv.ReplicaSubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.msg.kv.TouchRequest;
import com.couchbase.client.core.msg.kv.UnlockRequest;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.search.ServerSearchRequest;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

class AppTelemetryRequestClassifier {
    private static final Map<Class<?>, AppTelemetryRequestType> appTelemetryTypes;

    private AppTelemetryRequestClassifier() {
    }

    @Nullable
    static AppTelemetryRequestType classify(Request<?> request) {
        AppTelemetryRequestType type = appTelemetryTypes.get(request.getClass());
        if (type != null) {
            return type;
        }
        if (request instanceof SyncDurabilityRequest) {
            return ((SyncDurabilityRequest)((Object)request)).durabilityLevel().isPresent() ? AppTelemetryRequestType.KV_MUTATION_DURABLE : AppTelemetryRequestType.KV_MUTATION_NONDURABLE;
        }
        if (request instanceof CoreHttpRequest) {
            switch (request.serviceType()) {
                case EVENTING: {
                    return AppTelemetryRequestType.EVENTING;
                }
                case MANAGER: {
                    return AppTelemetryRequestType.MANAGEMENT;
                }
            }
            return null;
        }
        return null;
    }

    static {
        List<Class> retrievals = CbCollections.listOf(GetRequest.class, ReplicaGetRequest.class, SubdocGetRequest.class, ReplicaSubdocGetRequest.class, GetMetaRequest.class);
        List<Class> nonDurableMutations = CbCollections.listOf(TouchRequest.class, GetAndTouchRequest.class, GetAndLockRequest.class, UnlockRequest.class);
        HashMap<Class<AnalyticsRequest>, AppTelemetryRequestType> map = new HashMap<Class<AnalyticsRequest>, AppTelemetryRequestType>();
        retrievals.forEach(it -> map.put((Class<AnalyticsRequest>)it, AppTelemetryRequestType.KV_RETRIEVAL));
        nonDurableMutations.forEach(it -> map.put((Class<AnalyticsRequest>)it, AppTelemetryRequestType.KV_MUTATION_NONDURABLE));
        map.put(QueryRequest.class, AppTelemetryRequestType.QUERY);
        map.put(ServerSearchRequest.class, AppTelemetryRequestType.SEARCH);
        map.put(AnalyticsRequest.class, AppTelemetryRequestType.ANALYTICS);
        appTelemetryTypes = Collections.unmodifiableMap(map);
    }
}

