/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.msg.query.PreparedStatement;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.util.LRUCache;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Mono;

@Stability.Internal
public abstract class PreparedStatementStrategy {
    private final Core core;
    protected final Map<String, PreparedStatement> cache;

    public PreparedStatementStrategy(Core core, int cacheSize) {
        this.core = Objects.requireNonNull(core);
        this.cache = Collections.synchronizedMap(new LRUCache(cacheSize));
    }

    protected RequestTracer requestTracer() {
        return this.core.context().coreResources().requestTracer();
    }

    public abstract Mono<QueryResponse> execute(QueryRequest var1);

    protected Mono<QueryResponse> executeAlreadyPrepared(QueryRequest request, PreparedStatement prepared) {
        return this.executeAdhoc(request.toExecuteRequest(prepared.name(), prepared.encodedPlan(), this.requestTracer()));
    }

    public Mono<QueryResponse> executeAdhoc(QueryRequest request) {
        return Mono.defer(() -> {
            this.core.send(request);
            return Reactor.wrap(request, request.response(), true).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete((Throwable)err));
        });
    }

    public void evict(QueryRequest request) {
        this.cache.remove(request.statement());
    }
}

