/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreKvResponseMetadata;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import java.util.HashMap;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class MeteringUnits {
    @Nullable
    public final Integer readUnits;
    @Nullable
    public final Integer writeUnits;

    public MeteringUnits(@Nullable Integer readUnits, @Nullable Integer writeUnits) {
        this.readUnits = readUnits;
        this.writeUnits = writeUnits;
    }

    @Nullable
    public static MeteringUnits from(Throwable err) {
        CouchbaseException ce;
        if (err instanceof CouchbaseException && (ce = (CouchbaseException)err).context() != null && ce.context() instanceof KeyValueErrorContext) {
            KeyValueErrorContext kvec = (KeyValueErrorContext)ce.context();
            HashMap<String, Object> map = new HashMap<String, Object>();
            kvec.injectExportableParams(map);
            Integer readUnits = (Integer)map.get("readUnits");
            Integer writeUnits = (Integer)map.get("readUnits");
            if (readUnits != null || writeUnits != null) {
                return new MeteringUnits(readUnits, writeUnits);
            }
            return null;
        }
        return null;
    }

    @Stability.Internal
    public static class MeteringUnitsBuilder {
        private int readUnits;
        private int writeUnits;

        public int readUnits() {
            return this.readUnits;
        }

        public int writeUnits() {
            return this.writeUnits;
        }

        public void add(@Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
            if (flexibleExtras != null) {
                if (flexibleExtras.readUnits != -1) {
                    this.readUnits += flexibleExtras.readUnits;
                }
                if (flexibleExtras.writeUnits != -1) {
                    this.writeUnits += flexibleExtras.writeUnits;
                }
            }
        }

        public void add(CoreKvResponseMetadata meta) {
            if (meta.readUnits() != null) {
                this.readUnits += meta.readUnits().intValue();
            }
            if (meta.writeUnits() != null) {
                this.writeUnits += meta.writeUnits().intValue();
            }
        }

        public void add(Throwable err) {
            this.add(MeteringUnits.from(err));
        }

        public void add(@Nullable MeteringUnits units) {
            if (units != null) {
                if (units.readUnits != null) {
                    this.readUnits += units.readUnits.intValue();
                }
                if (units.writeUnits != null) {
                    this.writeUnits += units.writeUnits.intValue();
                }
            }
        }

        public MeteringUnits build() {
            return new MeteringUnits(this.readUnits == 0 ? null : Integer.valueOf(this.readUnits), this.writeUnits == 0 ? null : Integer.valueOf(this.writeUnits));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.readUnits > 0) {
                sb.append(" RUs=");
                sb.append(this.readUnits);
            }
            if (this.writeUnits > 0) {
                sb.append(" WUs=");
                sb.append(this.writeUnits);
            }
            return sb.toString();
        }
    }
}

