/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.components.DocRecord;
import com.couchbase.client.core.transaction.forwards.ForwardCompatibility;
import com.couchbase.client.core.transaction.support.AttemptState;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class ActiveTransactionRecordEntry {
    private final String atrBucket;
    private final String atrId;
    private final String attemptId;
    private final Optional<String> transactionId;
    private final AttemptState state;
    private final Optional<Long> timestampStartMillis;
    private final Optional<Long> timestampCommitMillis;
    private final Optional<Long> timestampCompleteMillis;
    private final Optional<Long> timestampRollBackMillis;
    private final Optional<Long> timestampRolledBackMillis;
    private final Optional<Integer> expiresAfterMillis;
    private final long cas;
    private final Optional<List<DocRecord>> insertedIds;
    private final Optional<List<DocRecord>> replacedIds;
    private final Optional<List<DocRecord>> removedIds;
    private final Optional<ForwardCompatibility> forwardCompatibility;
    private final Optional<DurabilityLevel> durabilityLevel;

    public ActiveTransactionRecordEntry(String atrBucket, String atrId, String attemptId, Optional<String> transactionId, AttemptState state, Optional<Long> timestampStartMillis, Optional<Long> timestampCommitMillis, Optional<Long> timestampCompleteMillis, Optional<Long> timestampRollBackMillis, Optional<Long> timestampRolledBackMillis, Optional<Integer> expiresAfterMillis, Optional<List<DocRecord>> insertedIds, Optional<List<DocRecord>> replacedIds, Optional<List<DocRecord>> removedIds, long cas, Optional<ForwardCompatibility> forwardCompatibility, Optional<DurabilityLevel> durabilityLevel) {
        this.atrId = Objects.requireNonNull(atrId);
        this.atrBucket = Objects.requireNonNull(atrBucket);
        this.attemptId = Objects.requireNonNull(attemptId);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.state = Objects.requireNonNull(state);
        this.timestampStartMillis = Objects.requireNonNull(timestampStartMillis);
        this.timestampCommitMillis = Objects.requireNonNull(timestampCommitMillis);
        this.timestampCompleteMillis = Objects.requireNonNull(timestampCompleteMillis);
        this.timestampRollBackMillis = Objects.requireNonNull(timestampRollBackMillis);
        this.timestampRolledBackMillis = Objects.requireNonNull(timestampRolledBackMillis);
        this.expiresAfterMillis = Objects.requireNonNull(expiresAfterMillis);
        this.cas = cas;
        this.insertedIds = Objects.requireNonNull(insertedIds);
        this.replacedIds = Objects.requireNonNull(replacedIds);
        this.removedIds = Objects.requireNonNull(removedIds);
        this.forwardCompatibility = Objects.requireNonNull(forwardCompatibility);
        this.durabilityLevel = Objects.requireNonNull(durabilityLevel);
    }

    public boolean hasExpired() {
        return this.hasExpired(0L);
    }

    public boolean hasExpired(long safetyMarginMillis) {
        long casInMillis = this.cas / 1000000L;
        if (!this.expiresAfterMillis.isPresent()) {
            return false;
        }
        return this.hasExpired(casInMillis, (long)this.expiresAfterMillis.get().intValue() + safetyMarginMillis);
    }

    public boolean hasExpired(long casInMillis, long txnExpiresAfterMillis) {
        if (this.timestampStartMillis.isPresent()) {
            return casInMillis - this.timestampStartMillis.get() > txnExpiresAfterMillis;
        }
        return false;
    }

    public long ageMillis() {
        return this.cas / 1000000L - this.timestampStartMillis().orElse(0L);
    }

    public String atrId() {
        return this.atrId;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public Optional<String> transactionId() {
        return this.transactionId;
    }

    public AttemptState state() {
        return this.state;
    }

    public Optional<Long> timestampStartMillis() {
        return this.timestampStartMillis;
    }

    public long cas() {
        return this.cas;
    }

    public Optional<List<DocRecord>> insertedIds() {
        return this.insertedIds;
    }

    public Optional<List<DocRecord>> replacedIds() {
        return this.replacedIds;
    }

    public Optional<List<DocRecord>> removedIds() {
        return this.removedIds;
    }

    public Optional<Integer> expiresAfterMillis() {
        return this.expiresAfterMillis;
    }

    public Optional<ForwardCompatibility> forwardCompatibility() {
        return this.forwardCompatibility;
    }

    public Optional<DurabilityLevel> durabilityLevel() {
        return this.durabilityLevel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ATREntry{");
        sb.append("atr=").append(this.atrBucket).append('/').append(this.atrId);
        sb.append(",attemptId=").append(this.attemptId);
        sb.append(",state=").append((Object)this.state);
        sb.append(",expires=").append(this.expiresAfterMillis).append("ms");
        sb.append(",[age=").append(this.ageMillis()).append("ms");
        long casInMillis = this.cas / 1000000L;
        sb.append(",cas=").append(this.cas);
        sb.append("ns/");
        sb.append(casInMillis);
        sb.append("ms],inserted=").append(this.insertedIds);
        sb.append(",replaced=").append(this.replacedIds);
        sb.append(",removed=").append(this.removedIds);
        sb.append(",start=").append(this.timestampStartMillis).append("ms");
        sb.append(",fc=").append(this.forwardCompatibility.map(Object::toString).orElse("none"));
        sb.append(",dl=").append(this.durabilityLevel.map(Object::toString).orElse("n/a"));
        sb.append('}');
        return sb.toString();
    }
}

