/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.NanoTimestamp;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

@Stability.Internal
public class Deadline {
    private final NanoTimestamp start = NanoTimestamp.now();
    private final Duration duration;

    private Deadline(Duration duration) {
        this.duration = Objects.requireNonNull(duration);
    }

    public static Deadline of(Duration duration) {
        return new Deadline(duration);
    }

    public static Deadline of(Duration duration, double scale) {
        return new Deadline(Duration.ofNanos((long)((double)duration.toNanos() * scale)));
    }

    public boolean exceeded() {
        return this.start.hasElapsed(this.duration);
    }

    public Optional<Duration> remaining() {
        Duration d = this.duration.minus(this.start.elapsed());
        return d.isZero() || d.isNegative() ? Optional.empty() : Optional.of(d);
    }

    public String toString() {
        return "Deadline{duration=" + this.duration + ", remaining=" + this.remaining() + '}';
    }
}

