/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.analytics;

import com.couchbase.client.core.endpoint.BaseEndpoint;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.JobQueueFullException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.io.netty.analytics.AnalyticsChunkResponseParser;
import com.couchbase.client.core.io.netty.chunk.ChunkedMessageHandler;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkHeader;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkRow;
import com.couchbase.client.core.msg.analytics.AnalyticsChunkTrailer;
import com.couchbase.client.core.msg.analytics.AnalyticsRequest;
import com.couchbase.client.core.msg.analytics.AnalyticsResponse;
import com.couchbase.client.core.retry.RetryReason;
import java.util.Optional;

public class AnalyticsMessageHandler
extends ChunkedMessageHandler<AnalyticsChunkHeader, AnalyticsChunkRow, AnalyticsChunkTrailer, AnalyticsResponse, AnalyticsRequest> {
    public AnalyticsMessageHandler(BaseEndpoint endpoint, EndpointContext endpointContext) {
        super(endpoint, endpointContext, new AnalyticsChunkResponseParser());
    }

    @Override
    protected Optional<RetryReason> qualifiesForRetry(CouchbaseException exception) {
        if (exception instanceof TemporaryFailureException || exception instanceof JobQueueFullException) {
            return Optional.of(RetryReason.ANALYTICS_TEMPORARY_FAILURE);
        }
        return Optional.empty();
    }
}

