/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service.strategy;

import com.couchbase.client.core.endpoint.Endpoint;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.service.EndpointSelectionStrategy;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinSelectionStrategy
implements EndpointSelectionStrategy {
    private final AtomicInteger skip = new AtomicInteger(0);

    @Override
    public <R extends Request<? extends Response>> Endpoint select(R request, List<Endpoint> endpoints) {
        int endpointsSize = endpoints.size();
        if (endpointsSize == 0) {
            return null;
        }
        int startIndex = RoundRobinSelectionStrategy.forcePositive(this.skip.incrementAndGet()) % endpointsSize;
        for (int i = 0; i < endpointsSize; ++i) {
            try {
                Endpoint endpoint = endpoints.get((startIndex + i) % endpointsSize);
                if (endpoint.state() != EndpointState.CONNECTED || !endpoint.freeToWrite()) continue;
                return endpoint;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    void setSkip(int newValue) {
        this.skip.set(newValue < 0 ? 0 : newValue);
    }

    int currentSkip() {
        return RoundRobinSelectionStrategy.forcePositive(this.skip.get());
    }

    private static int forcePositive(int i) {
        return i & Integer.MAX_VALUE;
    }
}

