/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.request.RequestNotRetriedEvent;
import com.couchbase.client.core.cnc.events.request.RequestRetryScheduledEvent;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.ProtostellarBaseRequest;
import com.couchbase.client.core.protostellar.ProtostellarContext;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.retry.RetryAction;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class RetryOrchestratorProtostellar {
    public static ProtostellarRequestBehaviour shouldRetry(CoreProtostellar core, ProtostellarRequest<?> request, RetryReason reason) {
        ProtostellarContext ctx = core.context();
        if (reason.alwaysRetry()) {
            return RetryOrchestratorProtostellar.retryWithDuration(ctx, request, RetryOrchestrator.controlledBackoff(request.retryAttempts()), reason);
        }
        try {
            ProtostellarBaseRequest wrapper = new ProtostellarBaseRequest(core, request);
            RetryAction retryAction = request.retryStrategy().shouldRetry(wrapper, reason).get();
            Optional<Duration> duration = retryAction.duration();
            if (duration.isPresent()) {
                Duration cappedDuration = RetryOrchestratorProtostellar.capDuration(duration.get(), request);
                return RetryOrchestratorProtostellar.retryWithDuration(ctx, request, cappedDuration, reason);
            }
            ctx.environment().eventBus().publish(new RequestNotRetriedEvent(Event.Severity.DEBUG, request.getClass(), request.context(), reason, null));
            return request.cancel(CancellationReason.noMoreRetries(reason));
        }
        catch (Throwable throwable) {
            ctx.environment().eventBus().publish(new RequestNotRetriedEvent(Event.Severity.INFO, request.getClass(), request.context(), reason, throwable));
            throw new IllegalStateException("Internal bug - should not reach here");
        }
    }

    private static ProtostellarRequestBehaviour retryWithDuration(ProtostellarContext ctx, ProtostellarRequest<?> request, Duration duration, RetryReason reason) {
        Duration cappedDuration = RetryOrchestratorProtostellar.capDuration(duration, request);
        ctx.environment().eventBus().publish(new RequestRetryScheduledEvent(cappedDuration, request.context(), request.getClass(), reason));
        request.incrementRetryAttempts(cappedDuration, reason);
        return ProtostellarRequestBehaviour.retry(cappedDuration);
    }

    @Stability.Internal
    public static Duration capDuration(Duration uncappedDuration, ProtostellarRequest<?> request) {
        long absoluteTimeout;
        long theoreticalTimeout = System.nanoTime() + uncappedDuration.toNanos();
        long timeoutDelta = theoreticalTimeout - (absoluteTimeout = request.absoluteTimeout());
        if (timeoutDelta > 0L) {
            Duration cappedDuration = uncappedDuration.minus(Duration.ofNanos(timeoutDelta));
            if (cappedDuration.isNegative()) {
                return uncappedDuration;
            }
            return cappedDuration;
        }
        return uncappedDuration;
    }
}

