/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.AuthenticationStatus;
import com.couchbase.client.core.diagnostics.InternalEndpointDiagnostics;
import com.couchbase.client.core.service.ServiceType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class AuthErrorDecider {
    public static boolean isAuthError(List<InternalEndpointDiagnostics> endpointDiagnostics) {
        return endpointDiagnostics.stream().anyMatch(ed -> AuthErrorDecider.isGcccpEndpoint(ed) && ed.authenticationStatus == AuthenticationStatus.FAILED);
    }

    public static boolean isAuthError(Stream<InternalEndpointDiagnostics> endpointDiagnostics) {
        return AuthErrorDecider.isAuthError(endpointDiagnostics.collect(Collectors.toList()));
    }

    private static boolean isGcccpEndpoint(InternalEndpointDiagnostics ed) {
        return ed.internal.type() == ServiceType.KV && !ed.internal.namespace().isPresent();
    }

    @Nullable
    public static Throwable getTlsHandshakeFailure(Core core) {
        return core.internalDiagnostics().filter(AuthErrorDecider::isGcccpEndpoint).map(it -> it.tlsHandshakeFailure).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

