/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBuildQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreatePrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreCreateQueryIndexSharedOptions;
import com.couchbase.client.core.api.manager.CoreDropPrimaryQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreDropQueryIndexOptions;
import com.couchbase.client.core.api.manager.CoreGetAllQueryIndexesOptions;
import com.couchbase.client.core.api.manager.CoreQueryIndex;
import com.couchbase.client.core.api.manager.CoreScopeAndCollection;
import com.couchbase.client.core.api.manager.CoreWatchQueryIndexesOptions;
import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOps;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.core.api.query.CoreQueryProfile;
import com.couchbase.client.core.api.query.CoreQueryResult;
import com.couchbase.client.core.api.query.CoreQueryScanConsistency;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.IndexExistsException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.error.IndexesNotReadyException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreQueryType;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.transaction.config.CoreSingleQueryTransactionOptions;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.Validators;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreCollectionQueryIndexManager {
    private final CoreQueryOps queryOps;
    private final RequestTracer requestTracer;
    private final CoreKeyspace collection;
    private final CoreQueryContext queryContext;

    public CoreCollectionQueryIndexManager(CoreQueryOps queryOps, RequestTracer requestTracer, CoreKeyspace collection) {
        this.queryOps = Objects.requireNonNull(queryOps);
        this.requestTracer = Objects.requireNonNull(requestTracer);
        this.collection = Objects.requireNonNull(collection);
        this.queryContext = CoreQueryContext.of(collection.bucket(), collection.scope());
    }

    public ObjectNode getNamedParamsForGetAllIndexes() {
        ObjectNode params = Mapper.createObjectNode();
        params.put("bucketName", this.collection.bucket());
        params.put("scopeName", this.collection.scope());
        params.put("collectionName", this.collection.collection());
        return params;
    }

    public String getStatementForGetAllIndexes() {
        String whereCondition = "(bucket_id = $bucketName AND scope_id = $scopeName AND keyspace_id = $collectionName)";
        if (this.collection.isDefaultCollection()) {
            String defaultCollectionCondition = "(bucket_id IS MISSING AND keyspace_id = $bucketName)";
            whereCondition = "(" + whereCondition + " OR " + defaultCollectionCondition + ")";
        }
        return "SELECT idx.* FROM system:indexes AS idx WHERE " + whereCondition + " AND `using` = \"gsi\" ORDER BY is_primary DESC, name ASC";
    }

    public CompletableFuture<Void> createIndex(String indexName, Collection<String> fields, CoreCreateQueryIndexOptions options) {
        Validators.notNullOrEmpty(indexName, "IndexName");
        Validators.notNullOrEmpty(fields, "Fields");
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        String keyspace = this.buildKeyspace();
        String statement = "CREATE INDEX " + CoreCollectionQueryIndexManager.quote(indexName) + " ON " + keyspace + CoreCollectionQueryIndexManager.formatIndexFields(fields);
        Map<String, Object> with = CoreCollectionQueryIndexManager.createIndexWith(options);
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, with, options.commonOptions(), "manager_query_create_index", null).exceptionally(t -> {
            if (options.ignoreIfExists() && CbThrowables.hasCause(t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> createPrimaryIndex(CoreCreatePrimaryQueryIndexOptions options) {
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        String keyspace = this.buildKeyspace();
        String statement = "CREATE PRIMARY INDEX ";
        if (options.indexName() != null) {
            statement = statement + CoreCollectionQueryIndexManager.quote(options.indexName()) + " ";
        }
        statement = statement + "ON " + keyspace;
        Map<String, Object> with = CoreCollectionQueryIndexManager.createIndexWith(options);
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, with, options.commonOptions(), "manager_query_create_primary_index", null).exceptionally(t -> {
            if (options.ignoreIfExists() && CbThrowables.hasCause(t, IndexExistsException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<List<CoreQueryIndex>> getAllIndexes(CoreGetAllQueryIndexesOptions options) {
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeName(), options.collectionName());
        String statement = this.getStatementForGetAllIndexes();
        ObjectNode params = this.getNamedParamsForGetAllIndexes();
        return this.exec(CoreQueryType.READ_ONLY, statement, options.commonOptions(), "manager_query_get_all_indexes", params).thenApply(result -> result.rows().map(CoreQueryIndex::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropPrimaryIndex(CoreDropPrimaryQueryIndexOptions options) {
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        String keyspace = this.buildKeyspace();
        String statement = "DROP PRIMARY INDEX ON " + keyspace;
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_drop_primary_index", null).exceptionally(t -> {
            if (options.ignoreIfNotExists() && CbThrowables.hasCause(t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> dropIndex(String indexName, CoreDropQueryIndexOptions options) {
        Validators.notNullOrEmpty(indexName, "IndexName");
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        String keyspace = this.buildKeyspace();
        String statement = "DROP INDEX " + CoreCollectionQueryIndexManager.quote(indexName) + " ON " + keyspace;
        return ((CompletableFuture)this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_drop_index", null).exceptionally(t -> {
            if (options.ignoreIfNotExists() && CbThrowables.hasCause(t, IndexNotFoundException.class)) {
                return null;
            }
            CbThrowables.throwIfUnchecked(t);
            throw new RuntimeException((Throwable)t);
        })).thenApply(result -> null);
    }

    public CompletableFuture<Void> buildDeferredIndexes(CoreBuildQueryIndexOptions options) {
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        CoreGetAllQueryIndexesOptions getAllOptions = this.createGetAllOptions(options.commonOptions());
        return Reactor.toMono(() -> this.getAllIndexes(getAllOptions)).map(indexes -> indexes.stream().filter(idx -> idx.state().equals("deferred")).map(idx -> CoreCollectionQueryIndexManager.quote(idx.name())).collect(Collectors.toList())).flatMap(indexNames -> {
            if (indexNames.isEmpty()) {
                return Mono.empty();
            }
            String keyspace = this.buildKeyspace();
            String statement = "BUILD INDEX ON " + keyspace + " (" + String.join((CharSequence)",", indexNames) + ")";
            return Reactor.toMono(() -> this.exec(CoreQueryType.WRITE, statement, options.commonOptions(), "manager_query_build_deferred_indexes", null).thenApply(result -> null));
        }).then().toFuture();
    }

    public CompletableFuture<Void> watchIndexes(Collection<String> indexNames, Duration timeout, CoreWatchQueryIndexesOptions options) {
        Validators.notNull(indexNames, "IndexNames");
        Validators.notNull(timeout, "Timeout");
        Validators.notNull(options, "Options");
        this.checkScopeAndCollection(options.scopeAndCollection());
        HashSet<String> indexNameSet = new HashSet<String>(indexNames);
        RequestSpan parent = this.requestTracer.requestSpan("manager_query_watch_indexes", null);
        return Mono.fromFuture(() -> this.failIfIndexesOffline(indexNameSet, options.watchPrimary(), parent)).retryWhen(Retry.onlyIf(ctx -> CbThrowables.hasCause(ctx.exception(), IndexesNotReadyException.class)).exponentialBackoff(Duration.ofMillis(50L), Duration.ofSeconds(1L)).timeout(timeout).toReactorRetry()).onErrorMap(t -> CoreCollectionQueryIndexManager.toWatchTimeoutException(t, timeout)).toFuture().whenComplete((r, t) -> parent.end());
    }

    public static String formatIndexFields(Collection<String> fields) {
        return "(" + String.join((CharSequence)",", fields) + ")";
    }

    public static Throwable toWatchTimeoutException(Throwable t, Duration timeout) {
        if (t instanceof RetryExhaustedException || t instanceof TimeoutException) {
            StringBuilder msg = new StringBuilder("A requested index is still not ready after " + timeout + ".");
            CbThrowables.findCause(t, IndexesNotReadyException.class).ifPresent(cause -> msg.append(" Unready index name -> state: ").append(RedactableArgument.redactMeta(cause.indexNameToState())));
            return new UnambiguousTimeoutException(msg.toString(), null);
        }
        return t;
    }

    private CompletableFuture<Void> failIfIndexesOffline(Set<String> indexNames, boolean includePrimary, RequestSpan parentSpan) throws IndexesNotReadyException, IndexNotFoundException {
        Objects.requireNonNull(indexNames);
        CoreGetAllQueryIndexesOptions getAllQueryIndexesOptions = this.createGetAllOptions(CoreCommonOptions.of(null, null, parentSpan));
        return this.getAllIndexes(getAllQueryIndexesOptions).thenApply(allIndexes -> CoreCollectionQueryIndexManager.failIfIndexesOfflineHelper(indexNames, includePrimary, allIndexes));
    }

    public static Void failIfIndexesOfflineHelper(Set<String> indexNames, boolean includePrimary, List<CoreQueryIndex> allIndexes) {
        List matchingIndexes = allIndexes.stream().filter(idx -> indexNames.contains(idx.name()) || includePrimary && idx.primary()).collect(Collectors.toList());
        boolean primaryIndexPresent = matchingIndexes.stream().anyMatch(CoreQueryIndex::primary);
        if (includePrimary && !primaryIndexPresent) {
            throw new IndexNotFoundException("#primary");
        }
        Set matchingIndexNames = matchingIndexes.stream().map(CoreQueryIndex::name).collect(Collectors.toSet());
        Set<String> missingIndexNames = CoreCollectionQueryIndexManager.difference(indexNames, matchingIndexNames);
        if (!missingIndexNames.isEmpty()) {
            throw new IndexNotFoundException(missingIndexNames.toString());
        }
        Map<String, String> offlineIndexNameToState = matchingIndexes.stream().filter(idx -> !"online".equals(idx.state())).collect(Collectors.toMap(CoreQueryIndex::name, CoreQueryIndex::state));
        if (!offlineIndexNameToState.isEmpty()) {
            throw new IndexesNotReadyException(offlineIndexNameToState);
        }
        return null;
    }

    private static <T> Set<T> difference(Set<T> lhs, Set<T> rhs) {
        HashSet<T> result = new HashSet<T>(lhs);
        result.removeAll(rhs);
        return result;
    }

    private CoreGetAllQueryIndexesOptions createGetAllOptions(final CoreCommonOptions options) {
        return new CoreGetAllQueryIndexesOptions(){

            @Override
            public String scopeName() {
                return null;
            }

            @Override
            public String collectionName() {
                return null;
            }

            @Override
            public CoreCommonOptions commonOptions() {
                return options;
            }
        };
    }

    private CompletableFuture<CoreQueryResult> exec(CoreQueryType queryType, CharSequence statement, @Nullable Map<String, Object> with, CoreCommonOptions options, String spanName, ObjectNode parameters) {
        return with == null || with.isEmpty() ? this.exec(queryType, statement, options, spanName, parameters) : this.exec(queryType, statement + " WITH " + Mapper.encodeAsString(with), options, spanName, parameters);
    }

    private CompletableFuture<CoreQueryResult> exec(CoreQueryType queryType, CharSequence statement, CoreCommonOptions options, String spanName, ObjectNode parameters) {
        RequestSpan parent = this.requestTracer.requestSpan(spanName, options.parentSpan().orElse(null));
        CoreCommonOptions common = CoreCommonOptions.ofOptional(options.timeout(), options.retryStrategy(), Optional.of(parent));
        CoreQueryOptions queryOpts = CoreCollectionQueryIndexManager.toQueryOptions(common, Objects.requireNonNull(queryType) == CoreQueryType.READ_ONLY, parameters);
        parent.attribute("db.name", this.collection.bucket());
        parent.attribute("db.couchbase.scope", this.collection.scope());
        parent.attribute("db.couchbase.collection", this.collection.collection());
        return this.queryOps.queryAsync(statement.toString(), queryOpts, this.queryContext, null, null).toFuture().whenComplete((r, t) -> parent.end());
    }

    public static CoreQueryOptions toQueryOptions(final CoreCommonOptions options, final boolean readonly, final ObjectNode parameters) {
        return new CoreQueryOptions(){

            @Override
            public boolean adhoc() {
                return true;
            }

            @Override
            public String clientContextId() {
                return null;
            }

            @Override
            public CoreMutationState consistentWith() {
                return null;
            }

            @Override
            public Integer maxParallelism() {
                return null;
            }

            @Override
            public boolean metrics() {
                return false;
            }

            @Override
            public ObjectNode namedParameters() {
                return parameters;
            }

            @Override
            public Integer pipelineBatch() {
                return null;
            }

            @Override
            public Integer pipelineCap() {
                return null;
            }

            @Override
            public ArrayNode positionalParameters() {
                return null;
            }

            @Override
            public CoreQueryProfile profile() {
                return null;
            }

            @Override
            public JsonNode raw() {
                return null;
            }

            @Override
            public boolean readonly() {
                return readonly;
            }

            @Override
            public Duration scanWait() {
                return null;
            }

            @Override
            public Integer scanCap() {
                return null;
            }

            @Override
            public CoreQueryScanConsistency scanConsistency() {
                return null;
            }

            @Override
            public boolean flexIndex() {
                return false;
            }

            @Override
            public Boolean preserveExpiry() {
                return null;
            }

            @Override
            public Boolean useReplica() {
                return null;
            }

            @Override
            public CoreSingleQueryTransactionOptions asTransactionOptions() {
                return null;
            }

            @Override
            public CoreCommonOptions commonOptions() {
                return options;
            }
        };
    }

    private static String quote(String s) {
        if (s.contains("`")) {
            throw InvalidArgumentException.fromMessage("Value [" + RedactableArgument.redactMeta(s) + "] may not contain backticks.");
        }
        return "`" + s + "`";
    }

    public static String quote(String ... components) {
        return Arrays.stream(components).map(CoreCollectionQueryIndexManager::quote).collect(Collectors.joining("."));
    }

    public static String quote(CoreKeyspace keyspace) {
        return CoreCollectionQueryIndexManager.quote(keyspace.bucket()) + "." + CoreCollectionQueryIndexManager.quote(keyspace.scope()) + "." + CoreCollectionQueryIndexManager.quote(keyspace.collection());
    }

    private String buildKeyspace() {
        return CoreCollectionQueryIndexManager.quote(this.collection);
    }

    private void checkScopeAndCollection(@Nullable CoreScopeAndCollection scopeAndCollection) {
        if (scopeAndCollection != null) {
            throw InvalidArgumentException.fromMessage("scopeName and collectionName should not be used together with CollectionQueryIndexManager, which is already acting on a particular Collection");
        }
    }

    private void checkScopeAndCollection(@Nullable String scopeName, @Nullable String collectionName) {
        if (scopeName != null || collectionName != null) {
            throw InvalidArgumentException.fromMessage("scopeName and collectionName should not be used together with CollectionQueryIndexManager, which is already acting on a particular Collection");
        }
    }

    @Nullable
    public static Map<String, Object> createIndexWith(CoreCreateQueryIndexSharedOptions options) {
        HashMap<String, Object> with = new HashMap<String, Object>();
        if (options.with() != null) {
            with.putAll(options.with());
        }
        if (options.numReplicas() != null) {
            if (options.numReplicas() < 0) {
                throw InvalidArgumentException.fromMessage("numReplicas must be >= 0");
            }
            with.put("num_replica", options.numReplicas());
        }
        if (options.deferred() != null) {
            with.put("defer_build", options.deferred());
        }
        if (with.isEmpty()) {
            return null;
        }
        return with;
    }
}

