/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS.utils;

import com.couchbase.client.core.deps.org.xbill.DNS.utils.BaseUtils;
import java.io.ByteArrayOutputStream;

public class base16 {
    private static final String BASE_16_CHARS = "0123456789ABCDEF";

    private base16() {
    }

    public static String toString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte item : b) {
            short value = (short)(item & 0xFF);
            byte high = (byte)(value >> 4);
            byte low = (byte)(value & 0xF);
            sb.append(BASE_16_CHARS.charAt(high));
            sb.append(BASE_16_CHARS.charAt(low));
        }
        return sb.toString();
    }

    public static String toString(byte[] b, int lineLength, String prefix, boolean addClose) {
        return BaseUtils.wrapLines(base16.toString(b), lineLength, prefix, addClose);
    }

    public static byte[] fromString(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new byte[0];
        }
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') {
                bs.write(c);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                bs.write(c - 32);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            return null;
        }
        byte[] in = bs.toByteArray();
        if ((in.length & 1) != 0) {
            return null;
        }
        bs.reset();
        for (int i = 0; i < in.length; i += 2) {
            byte high = (byte)BASE_16_CHARS.indexOf(in[i]);
            byte low = (byte)BASE_16_CHARS.indexOf(in[i + 1]);
            bs.write((high << 4) + (low & 0xF));
        }
        return bs.toByteArray();
    }
}

