/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.transaction.TransactionCleanupStartRunEvent;
import com.couchbase.client.core.cnc.events.transaction.TransactionEvent;
import com.couchbase.client.core.transaction.cleanup.ActiveTransactionRecordStats;
import com.couchbase.client.core.transaction.components.ActiveTransactionRecordEntry;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Stability.Uncommitted
public class TransactionCleanupEndRunEvent
extends TransactionEvent {
    private final TransactionCleanupStartRunEvent start;
    private final Duration timeOfLastRun;
    private int numAtrsChecked;
    private int numEntries;
    private long numAtrsPresent;
    private long numAtrsMissing;
    private long numAtrsErrored;
    private final Map<String, ActiveTransactionRecordStats> atrStats;
    private Optional<ActiveTransactionRecordEntry> oldest = Optional.empty();
    private int numEntriesExpired;
    private int numEntriesAttemptsFailed;
    private int largestNumEntries;

    @Stability.Volatile
    public TransactionCleanupEndRunEvent(TransactionCleanupStartRunEvent start, Map<String, ActiveTransactionRecordStats> atrStats, Duration timeOfLastRun) {
        super(Event.Severity.INFO, "com.couchbase.transactions.cleanup.stats");
        this.start = Objects.requireNonNull(start);
        this.atrStats = Objects.requireNonNull(atrStats);
        Collection<ActiveTransactionRecordStats> atrs = atrStats.values();
        this.numAtrsChecked = atrs.size();
        atrs.forEach(stats -> {
            if (stats.errored.isPresent()) {
                ++this.numAtrsErrored;
            }
            this.numEntries += stats.numEntries;
            if (stats.numEntries > this.largestNumEntries) {
                this.largestNumEntries = stats.numEntries;
            }
            if (stats.exists) {
                ++this.numAtrsPresent;
            } else {
                ++this.numAtrsMissing;
            }
            this.numEntriesExpired += stats.expired.size();
            this.numEntriesAttemptsFailed += stats.expiredEntryCleanupFailedAttempts.get();
            if (stats.oldest().isPresent() && (!this.oldest.isPresent() || stats.oldest().get().ageMillis() > this.oldest.get().ageMillis())) {
                this.oldest = stats.oldest();
            }
        });
        this.timeOfLastRun = Objects.requireNonNull(timeOfLastRun);
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder(300);
        sb.append("start={");
        sb.append(this.start.description());
        sb.append("},end={taken=");
        sb.append(this.timeOfLastRun.toMillis());
        sb.append("millis,ATRs={tried=");
        sb.append(this.numAtrsChecked);
        sb.append(",present=");
        sb.append(this.numAtrsPresent);
        sb.append(",errored=");
        sb.append(this.numAtrsErrored);
        sb.append("},entries={expired=");
        sb.append(this.numEntriesExpired);
        sb.append(",failed=");
        sb.append(this.numEntriesAttemptsFailed);
        sb.append(",total=");
        sb.append(this.numEntries);
        sb.append("},largestNumEntries=");
        sb.append(this.largestNumEntries);
        if (this.oldest.isPresent()) {
            sb.append(",oldest=");
            ActiveTransactionRecordEntry o = this.oldest.get();
            sb.append(o.ageMillis());
            sb.append("millis,id=");
            sb.append(o.atrId());
            sb.append("/");
            sb.append(o.attemptId().substring(0, 5));
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }
}

