/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.KeyValueBaseResponse;
import com.couchbase.client.core.msg.kv.MutationToken;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class InsertResponse
extends KeyValueBaseResponse {
    private final long cas;
    private final Optional<MutationToken> mutationToken;

    InsertResponse(ResponseStatus status, long cas, Optional<MutationToken> mutationToken, @Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        super(status, flexibleExtras);
        this.cas = cas;
        this.mutationToken = mutationToken;
    }

    public long cas() {
        return this.cas;
    }

    public Optional<MutationToken> mutationToken() {
        return this.mutationToken;
    }

    public RuntimeException errorIfNeeded(InsertRequest request) {
        if (this.status() == ResponseStatus.EXISTS) {
            throw new DocumentExistsException(KeyValueErrorContext.completedRequest(request, this));
        }
        return DefaultErrorUtil.keyValueStatusToException(request, this);
    }
}

