/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.logging;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.core.logging.LogRedaction;
import com.couchbase.client.core.logging.RedactionLevel;

public class RedactableArgument {
    private final ArgumentType type;
    private final Object message;

    private RedactableArgument(ArgumentType type, Object message) {
        this.type = type;
        this.message = message;
    }

    public static RedactableArgument redactUser(Object message) {
        return new RedactableArgument(ArgumentType.USER, message);
    }

    public static RedactableArgument redactMeta(Object message) {
        return new RedactableArgument(ArgumentType.META, message);
    }

    public static RedactableArgument redactSystem(Object message) {
        return new RedactableArgument(ArgumentType.SYSTEM, message);
    }

    public ArgumentType type() {
        return this.type;
    }

    public String message() {
        return String.valueOf(this.message);
    }

    @JsonValue
    public String toString() {
        boolean redact;
        if (this.type != ArgumentType.USER) {
            return this.message();
        }
        RedactionLevel redactionLevel = LogRedaction.getRedactionLevel();
        switch (redactionLevel) {
            case NONE: {
                redact = false;
                break;
            }
            case PARTIAL: {
                redact = this.type == ArgumentType.USER;
                break;
            }
            case FULL: {
                redact = true;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected redaction level: " + (Object)((Object)redactionLevel)));
            }
        }
        return redact ? "<" + this.type.tagName + ">" + this.message() + "</" + this.type.tagName + ">" : this.message();
    }

    private static enum ArgumentType {
        USER("ud"),
        META("md"),
        SYSTEM("sd");

        private final String tagName;

        private ArgumentType(String tagName) {
            this.tagName = tagName;
        }
    }
}

